package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats;
import java.lang.Class;
import java.lang.Long;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link ControlMessage} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ControlMessage createControlMessage(int fooXyzzy, int barBaz) {
 *         return new ControlMessageBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ControlMessage, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ControlMessage
 *
 */
@Generated("mdsal-binding-generator")
public class ControlMessageBuilder {

    private MessageType _msgType;
    private Long _rxCount;
    private Long _txCount;


    Map<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ControlMessageBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link ControlMessage}.
     *
     * @param base ControlMessage from which the builder should be initialized
     */
    public ControlMessageBuilder(ControlMessage base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._msgType = base.getMsgType();
        this._rxCount = base.getRxCount();
        this._txCount = base.getTxCount();
    }



    /**
     * Return current value associated with the property corresponding to {@link ControlMessage#getMsgType()}.
     *
     * @return current value
     */
    public MessageType getMsgType() {
        return _msgType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ControlMessage#getRxCount()}.
     *
     * @return current value
     */
    public Long getRxCount() {
        return _rxCount;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ControlMessage#getTxCount()}.
     *
     * @return current value
     */
    public Long getTxCount() {
        return _txCount;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ControlMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ControlMessage#getMsgType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControlMessageBuilder setMsgType(final MessageType value) {
        this._msgType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ControlMessage#getRxCount()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControlMessageBuilder setRxCount(final Long value) {
        this._rxCount = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ControlMessage#getTxCount()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControlMessageBuilder setTxCount(final Long value) {
        this._txCount = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ControlMessageBuilder addAugmentation(Augmentation<ControlMessage> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ControlMessageBuilder removeAugmentation(Class<? extends Augmentation<ControlMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ControlMessage} instance.
     *
     * @return A new {@link ControlMessage} instance.
     */
    public @NonNull ControlMessage build() {
        return new ControlMessageImpl(this);
    }

    private static final class ControlMessageImpl
        extends AbstractAugmentable<ControlMessage>
        implements ControlMessage {
    
        private final MessageType _msgType;
        private final Long _rxCount;
        private final Long _txCount;
    
        ControlMessageImpl(ControlMessageBuilder base) {
            super(base.augmentation);
            this._msgType = base.getMsgType();
            this._rxCount = base.getRxCount();
            this._txCount = base.getTxCount();
        }
    
        @Override
        public MessageType getMsgType() {
            return _msgType;
        }
        
        @Override
        public Long getRxCount() {
            return _rxCount;
        }
        
        @Override
        public Long getTxCount() {
            return _txCount;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ControlMessage.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ControlMessage.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ControlMessage.bindingToString(this);
        }
    }
}
