package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.Long;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ControlMessageStats} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ControlMessageStats createControlMessageStats(int fooXyzzy, int barBaz) {
 *         return new ControlMessageStatsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ControlMessageStats, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ControlMessageStats
 *
 */
@Generated("mdsal-binding-generator")
public class ControlMessageStatsBuilder {

    private List<ControlMessage> _controlMessage;
    private Long _rxUnknown;
    private Long _txErrors;


    Map<Class<? extends Augmentation<ControlMessageStats>>, Augmentation<ControlMessageStats>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ControlMessageStatsBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link CtrlMsgStats}.
     *
     * @param arg CtrlMsgStats from which the builder should be initialized
     */
    public ControlMessageStatsBuilder(CtrlMsgStats arg) {
        this._rxUnknown = arg.getRxUnknown();
        this._txErrors = arg.getTxErrors();
        this._controlMessage = arg.getControlMessage();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link ControlMessageStats}.
     *
     * @param base ControlMessageStats from which the builder should be initialized
     */
    public ControlMessageStatsBuilder(ControlMessageStats base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._controlMessage = base.getControlMessage();
        this._rxUnknown = base.getRxUnknown();
        this._txErrors = base.getTxErrors();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link CtrlMsgStats}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CtrlMsgStats castArg) {
            this._rxUnknown = castArg.getRxUnknown();
            this._txErrors = castArg.getTxErrors();
            this._controlMessage = castArg.getControlMessage();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[CtrlMsgStats]");
    }

    private static final class LazyEmpty {
        static final @NonNull ControlMessageStats INSTANCE = new ControlMessageStatsBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of ControlMessageStats.
     *
     * @return An empty {@link ControlMessageStats}
     */
    public static @NonNull ControlMessageStats empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link ControlMessageStats#getControlMessage()}.
     *
     * @return current value
     */
    public List<ControlMessage> getControlMessage() {
        return _controlMessage;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ControlMessageStats#getRxUnknown()}.
     *
     * @return current value
     */
    public Long getRxUnknown() {
        return _rxUnknown;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link ControlMessageStats#getTxErrors()}.
     *
     * @return current value
     */
    public Long getTxErrors() {
        return _txErrors;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ControlMessageStats>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link ControlMessageStats#getControlMessage()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ControlMessageStatsBuilder setControlMessage(final List<ControlMessage> values) {
        this._controlMessage = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link ControlMessageStats#getRxUnknown()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControlMessageStatsBuilder setRxUnknown(final Long value) {
        this._rxUnknown = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link ControlMessageStats#getTxErrors()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControlMessageStatsBuilder setTxErrors(final Long value) {
        this._txErrors = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ControlMessageStatsBuilder addAugmentation(Augmentation<ControlMessageStats> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ControlMessageStatsBuilder removeAugmentation(Class<? extends Augmentation<ControlMessageStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link ControlMessageStats} instance.
     *
     * @return A new {@link ControlMessageStats} instance.
     */
    public @NonNull ControlMessageStats build() {
        return new ControlMessageStatsImpl(this);
    }

    private static final class ControlMessageStatsImpl
        extends AbstractAugmentable<ControlMessageStats>
        implements ControlMessageStats {
    
        private final List<ControlMessage> _controlMessage;
        private final Long _rxUnknown;
        private final Long _txErrors;
    
        ControlMessageStatsImpl(ControlMessageStatsBuilder base) {
            super(base.augmentation);
            this._controlMessage = CodeHelpers.emptyToNull(base.getControlMessage());
            this._rxUnknown = base.getRxUnknown();
            this._txErrors = base.getTxErrors();
        }
    
        @Override
        public List<ControlMessage> getControlMessage() {
            return _controlMessage;
        }
        
        @Override
        public Long getRxUnknown() {
            return _rxUnknown;
        }
        
        @Override
        public Long getTxErrors() {
            return _txErrors;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ControlMessageStats.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ControlMessageStats.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ControlMessageStats.bindingToString(this);
        }
    }
}
