package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import java.lang.Class;
import java.lang.Override;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKeyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.MappingKey;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Describes the mappings belonging to the same Virtual Network Identifier
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * grouping db-instance {
 *   leaf vni {
 *     type vni-uri;
 *   }
 *   list mapping {
 *     key "eid-uri origin";
 *     ext:context-instance eid-context;
 *     leaf eid-uri {
 *       type eid-uri;
 *     }
 *     leaf origin {
 *       type mapping-origin;
 *     }
 *     leaf-list site-id {
 *       type lisp-proto:site-id;
 *     }
 *     uses lisp-proto:mapping-record-container;
 *     list xtr-id-mapping {
 *       config false;
 *       key xtr-id-uri;
 *       ext:context-instance xtrid-context;
 *       leaf xtr-id-uri {
 *         type xtr-id-uri;
 *       }
 *       uses lisp-proto:mapping-record-container;
 *     }
 *   }
 *   list authentication-key {
 *     key eid-uri;
 *     ext:context-instance eid-context;
 *     leaf eid-uri {
 *       type eid-uri;
 *     }
 *     uses lisp-proto:eid-container;
 *     uses lisp-proto:mapping-authkey-container;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface DbInstance
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("db-instance");

    @Override
    Class<? extends DbInstance> implementedInterface();
    
    /**
     * Return vni, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The 24-bit Virtual Network Identifier
     *     </code>
     * </pre>
     *
     * @return {@code VniUri} vni, or {@code null} if it is not present.
     *
     */
    VniUri getVni();
    
    /**
     * Return vni, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The 24-bit Virtual Network Identifier
     *     </code>
     * </pre>
     *
     * @return {@code VniUri} vni, guaranteed to be non-null.
     * @throws NoSuchElementException if vni is not present
     *
     */
    default @NonNull VniUri requireVni() {
        return CodeHelpers.require(getVni(), "vni");
    }
    
    /**
     * Return mapping, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A list of EID-to-RLOC mappings within the same Instance ID
     *     </code>
     * </pre>
     *
     * @return {@code Map<MappingKey, Mapping>} mapping, or {@code null} if it is not present.
     *
     */
    @Nullable Map<MappingKey, Mapping> getMapping();
    
    /**
     * Return mapping, or an empty list if it is not present.
     *
     * @return {@code Map<MappingKey, Mapping>} mapping, or an empty list if it is not present.
     *
     */
    default @NonNull Map<MappingKey, Mapping> nonnullMapping() {
        return CodeHelpers.nonnull(getMapping());
    }
    
    /**
     * Return authenticationKey, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A list of authentication keys for EID prefixes within the same Virtual Network
     *         Identifier
     *     </code>
     * </pre>
     *
     * @return {@code Map<AuthenticationKeyKey, AuthenticationKey>} authenticationKey, or {@code null} if it is not present.
     *
     */
    @Nullable Map<AuthenticationKeyKey, AuthenticationKey> getAuthenticationKey();
    
    /**
     * Return authenticationKey, or an empty list if it is not present.
     *
     * @return {@code Map<AuthenticationKeyKey, AuthenticationKey>} authenticationKey, or an empty list if it is not present.
     *
     */
    default @NonNull Map<AuthenticationKeyKey, AuthenticationKey> nonnullAuthenticationKey() {
        return CodeHelpers.nonnull(getAuthenticationKey());
    }

}

