package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetKeyOutput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GetKeyOutput createGetKeyOutput(int fooXyzzy, int barBaz) {
 *         return new GetKeyOutputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GetKeyOutput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GetKeyOutput
 *
 */
@Generated("mdsal-binding-generator")
public class GetKeyOutputBuilder {

    private MappingAuthkey _mappingAuthkey;


    Map<Class<? extends Augmentation<GetKeyOutput>>, Augmentation<GetKeyOutput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public GetKeyOutputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link MappingAuthkeyContainer}.
     *
     * @param arg MappingAuthkeyContainer from which the builder should be initialized
     */
    public GetKeyOutputBuilder(MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link GetKeyOutput}.
     *
     * @param base GetKeyOutput from which the builder should be initialized
     */
    public GetKeyOutputBuilder(GetKeyOutput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._mappingAuthkey = base.getMappingAuthkey();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link MappingAuthkeyContainer}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingAuthkeyContainer castArg) {
            this._mappingAuthkey = castArg.getMappingAuthkey();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MappingAuthkeyContainer]");
    }


    /**
     * Return current value associated with the property corresponding to {@link GetKeyOutput#getMappingAuthkey()}.
     *
     * @return current value
     */
    public MappingAuthkey getMappingAuthkey() {
        return _mappingAuthkey;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetKeyOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link GetKeyOutput#getMappingAuthkey()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GetKeyOutputBuilder setMappingAuthkey(final MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GetKeyOutputBuilder addAugmentation(Augmentation<GetKeyOutput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GetKeyOutputBuilder removeAugmentation(Class<? extends Augmentation<GetKeyOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link GetKeyOutput} instance.
     *
     * @return A new {@link GetKeyOutput} instance.
     */
    public @NonNull GetKeyOutput build() {
        return new GetKeyOutputImpl(this);
    }

    private static final class GetKeyOutputImpl
        extends AbstractAugmentable<GetKeyOutput>
        implements GetKeyOutput {
    
        private final MappingAuthkey _mappingAuthkey;
    
        GetKeyOutputImpl(GetKeyOutputBuilder base) {
            super(base.augmentation);
            this._mappingAuthkey = base.getMappingAuthkey();
        }
    
        @Override
        public MappingAuthkey getMappingAuthkey() {
            return _mappingAuthkey;
        }
    
        @Override
        public MappingAuthkey nonnullMappingAuthkey() {
            return Objects.requireNonNullElse(getMappingAuthkey(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkeyBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GetKeyOutput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GetKeyOutput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GetKeyOutput.bindingToString(this);
        }
    }
}
