package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.list.MappingRecordItem;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetMappingsOutput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GetMappingsOutput createGetMappingsOutput(int fooXyzzy, int barBaz) {
 *         return new GetMappingsOutputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GetMappingsOutput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GetMappingsOutput
 *
 */
@Generated("mdsal-binding-generator")
public class GetMappingsOutputBuilder {

    private List<MappingRecordItem> _mappingRecordItem;


    Map<Class<? extends Augmentation<GetMappingsOutput>>, Augmentation<GetMappingsOutput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public GetMappingsOutputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link MappingRecordList}.
     *
     * @param arg MappingRecordList from which the builder should be initialized
     */
    public GetMappingsOutputBuilder(MappingRecordList arg) {
        this._mappingRecordItem = arg.getMappingRecordItem();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link GetMappingsOutput}.
     *
     * @param base GetMappingsOutput from which the builder should be initialized
     */
    public GetMappingsOutputBuilder(GetMappingsOutput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._mappingRecordItem = base.getMappingRecordItem();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link MappingRecordList}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordList castArg) {
            this._mappingRecordItem = castArg.getMappingRecordItem();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MappingRecordList]");
    }


    /**
     * Return current value associated with the property corresponding to {@link GetMappingsOutput#getMappingRecordItem()}.
     *
     * @return current value
     */
    public List<MappingRecordItem> getMappingRecordItem() {
        return _mappingRecordItem;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetMappingsOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link GetMappingsOutput#getMappingRecordItem()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public GetMappingsOutputBuilder setMappingRecordItem(final List<MappingRecordItem> values) {
        this._mappingRecordItem = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GetMappingsOutputBuilder addAugmentation(Augmentation<GetMappingsOutput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GetMappingsOutputBuilder removeAugmentation(Class<? extends Augmentation<GetMappingsOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link GetMappingsOutput} instance.
     *
     * @return A new {@link GetMappingsOutput} instance.
     */
    public @NonNull GetMappingsOutput build() {
        return new GetMappingsOutputImpl(this);
    }

    private static final class GetMappingsOutputImpl
        extends AbstractAugmentable<GetMappingsOutput>
        implements GetMappingsOutput {
    
        private final List<MappingRecordItem> _mappingRecordItem;
    
        GetMappingsOutputImpl(GetMappingsOutputBuilder base) {
            super(base.augmentation);
            this._mappingRecordItem = CodeHelpers.emptyToNull(base.getMappingRecordItem());
        }
    
        @Override
        public List<MappingRecordItem> getMappingRecordItem() {
            return _mappingRecordItem;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GetMappingsOutput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GetMappingsOutput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GetMappingsOutput.bindingToString(this);
        }
    }
}
