package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.DstSubscriberItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.SubscriberItem;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Notification sent when a mapping is changed
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * notification mapping-changed {
 *   leaf change-type {
 *     type mapping-change;
 *   }
 *   uses lisp-proto:mapping-record-container;
 *   uses lisp-proto:eid-container;
 *   list subscriber-item {
 *     uses lisp-proto:subscriber-data-grouping;
 *   }
 *   list dst-subscriber-item {
 *     uses lisp-proto:subscriber-data-grouping;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link MappingChangedBuilder}.
 * @see MappingChangedBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface MappingChanged
    extends
    DataObject,
    Notification<MappingChanged>,
    Augmentable<MappingChanged>,
    MappingRecordContainer,
    EidContainer
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mapping-changed");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.@NonNull MappingChanged obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getChangeType());
        result = prime * result + Objects.hashCode(obj.getDstSubscriberItem());
        result = prime * result + Objects.hashCode(obj.getEid());
        result = prime * result + Objects.hashCode(obj.getMappingRecord());
        result = prime * result + Objects.hashCode(obj.getSubscriberItem());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.@NonNull MappingChanged thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged.class, obj);
        return other != null
            && Objects.equals(thisObj.getChangeType(), other.getChangeType())
            && Objects.equals(thisObj.getDstSubscriberItem(), other.getDstSubscriberItem())
            && Objects.equals(thisObj.getEid(), other.getEid())
            && Objects.equals(thisObj.getMappingRecord(), other.getMappingRecord())
            && Objects.equals(thisObj.getSubscriberItem(), other.getSubscriberItem())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.@NonNull MappingChanged obj) {
        final var helper = MoreObjects.toStringHelper("MappingChanged");
        CodeHelpers.appendValue(helper, "changeType", obj.getChangeType());
        CodeHelpers.appendValue(helper, "dstSubscriberItem", obj.getDstSubscriberItem());
        CodeHelpers.appendValue(helper, "eid", obj.getEid());
        CodeHelpers.appendValue(helper, "mappingRecord", obj.getMappingRecord());
        CodeHelpers.appendValue(helper, "subscriberItem", obj.getSubscriberItem());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return changeType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The type of change
     *     </code>
     * </pre>
     *
     * @return {@code MappingChange} changeType, or {@code null} if it is not present.
     *
     */
    MappingChange getChangeType();
    
    /**
     * Return changeType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The type of change
     *     </code>
     * </pre>
     *
     * @return {@code MappingChange} changeType, guaranteed to be non-null.
     * @throws NoSuchElementException if changeType is not present
     *
     */
    default @NonNull MappingChange requireChangeType() {
        return CodeHelpers.require(getChangeType(), "changetype");
    }
    
    /**
     * Return subscriberItem, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The list of subscribers to be notified of this change.
     *     </code>
     * </pre>
     *
     * @return {@code List<SubscriberItem>} subscriberItem, or {@code null} if it is not present.
     *
     */
    @Nullable List<SubscriberItem> getSubscriberItem();
    
    /**
     * Return subscriberItem, or an empty list if it is not present.
     *
     * @return {@code List<SubscriberItem>} subscriberItem, or an empty list if it is not present.
     *
     */
    default @NonNull List<SubscriberItem> nonnullSubscriberItem() {
        return CodeHelpers.nonnull(getSubscriberItem());
    }
    
    /**
     * Return dstSubscriberItem, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         For Src/Dst EIDs, The list of the Dst subscribers to be notified of this change.
     *     </code>
     * </pre>
     *
     * @return {@code List<DstSubscriberItem>} dstSubscriberItem, or {@code null} if it is not present.
     *
     */
    @Nullable List<DstSubscriberItem> getDstSubscriberItem();
    
    /**
     * Return dstSubscriberItem, or an empty list if it is not present.
     *
     * @return {@code List<DstSubscriberItem>} dstSubscriberItem, or an empty list if it is not present.
     *
     */
    default @NonNull List<DstSubscriberItem> nonnullDstSubscriberItem() {
        return CodeHelpers.nonnull(getDstSubscriberItem());
    }

}

