package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifierKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The LISP EID-to-RLOC mapping database
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * container mapping-database {
 *   list virtual-network-identifier {
 *     key vni;
 *     ext:context-instance vni-context;
 *     uses db-instance;
 *   }
 *   container last-updated {
 *     config false;
 *     leaf last-updated {
 *       type int64;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link MappingDatabaseBuilder}.
 * @see MappingDatabaseBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface MappingDatabase
    extends
    ChildOf<OdlMappingserviceData>,
    Augmentable<MappingDatabase>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mapping-database");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.@NonNull MappingDatabase obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getLastUpdated());
        result = prime * result + Objects.hashCode(obj.getVirtualNetworkIdentifier());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.@NonNull MappingDatabase thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase.class, obj);
        return other != null
            && Objects.equals(thisObj.getLastUpdated(), other.getLastUpdated())
            && Objects.equals(thisObj.getVirtualNetworkIdentifier(), other.getVirtualNetworkIdentifier())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.@NonNull MappingDatabase obj) {
        final var helper = MoreObjects.toStringHelper("MappingDatabase");
        CodeHelpers.appendValue(helper, "lastUpdated", obj.getLastUpdated());
        CodeHelpers.appendValue(helper, "virtualNetworkIdentifier", obj.getVirtualNetworkIdentifier());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return virtualNetworkIdentifier, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A list of Virtual Network Identifiers
     *     </code>
     * </pre>
     *
     * @return {@code Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier>} virtualNetworkIdentifier, or {@code null} if it is not present.
     *
     */
    @Nullable Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier> getVirtualNetworkIdentifier();
    
    /**
     * Return virtualNetworkIdentifier, or an empty list if it is not present.
     *
     * @return {@code Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier>} virtualNetworkIdentifier, or an empty list if it is not present.
     *
     */
    default @NonNull Map<VirtualNetworkIdentifierKey, VirtualNetworkIdentifier> nonnullVirtualNetworkIdentifier() {
        return CodeHelpers.nonnull(getVirtualNetworkIdentifier());
    }
    
    /**
     * Return lastUpdated, or {@code null} if it is not present.
     *
     * @return {@code LastUpdated} lastUpdated, or {@code null} if it is not present.
     *
     */
    LastUpdated getLastUpdated();
    
    /**
     * Return lastUpdated, or an empty instance if it is not present.
     *
     * @return {@code LastUpdated} lastUpdated, or an empty instance if it is not present.
     *
     */
    @NonNull LastUpdated nonnullLastUpdated();

}

