package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * typedef mapping-origin {
 *   type enumeration {
 *     enum northbound;
 *     enum southbound;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum MappingOrigin implements EnumTypeObject {
    Northbound(0, "northbound"),
    
    Southbound(1, "southbound")
    ;

    private final @NonNull String name;
    private final int value;

    private MappingOrigin(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding MappingOrigin item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable MappingOrigin forName(String name) {
        return switch (name) {
            case "northbound" -> Northbound;
            case "southbound" -> Southbound;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding MappingOrigin item, or {@code null} if no such item exists
     */
    public static @Nullable MappingOrigin forValue(int intValue) {
        return switch (intValue) {
            case 0 -> Northbound;
            case 1 -> Southbound;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding MappingOrigin item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull MappingOrigin ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding MappingOrigin item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull MappingOrigin ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
