package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A list of authentication keys for EID prefixes within the same Virtual Network 
 * Identifier
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list authentication-key {
 *   key eid-uri;
 *   ext:context-instance eid-context;
 *   leaf eid-uri {
 *     type eid-uri;
 *   }
 *   uses lisp-proto:eid-container;
 *   uses lisp-proto:mapping-authkey-container;
 * }
 * </pre>
 * <p>To create instances of this class use {@link AuthenticationKeyBuilder}.
 * @see AuthenticationKeyBuilder
 * @see AuthenticationKeyKey
 *
 */
@Generated("mdsal-binding-generator")
public interface AuthenticationKey
    extends
    ChildOf<DbInstance>,
    Augmentable<AuthenticationKey>,
    EidContainer,
    MappingAuthkeyContainer,
    Identifiable<AuthenticationKeyKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("authentication-key");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.@NonNull AuthenticationKey obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getEid());
        result = prime * result + Objects.hashCode(obj.getEidUri());
        result = prime * result + Objects.hashCode(obj.getMappingAuthkey());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.@NonNull AuthenticationKey thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey.class, obj);
        return other != null
            && Objects.equals(thisObj.getEidUri(), other.getEidUri())
            && Objects.equals(thisObj.getEid(), other.getEid())
            && Objects.equals(thisObj.getMappingAuthkey(), other.getMappingAuthkey())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.@NonNull AuthenticationKey obj) {
        final var helper = MoreObjects.toStringHelper("AuthenticationKey");
        CodeHelpers.appendValue(helper, "eid", obj.getEid());
        CodeHelpers.appendValue(helper, "eidUri", obj.getEidUri());
        CodeHelpers.appendValue(helper, "mappingAuthkey", obj.getMappingAuthkey());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    AuthenticationKeyKey key();
    
    /**
     * Return eidUri, or {@code null} if it is not present.
     *
     * @return {@code EidUri} eidUri, or {@code null} if it is not present.
     *
     */
    EidUri getEidUri();
    
    /**
     * Return eidUri, guaranteed to be non-null.
     *
     * @return {@code EidUri} eidUri, guaranteed to be non-null.
     * @throws NoSuchElementException if eidUri is not present
     *
     */
    default @NonNull EidUri requireEidUri() {
        return CodeHelpers.require(getEidUri(), "eiduri");
    }

}

