package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link AuthenticationKey} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     AuthenticationKey createAuthenticationKey(int fooXyzzy, int barBaz) {
 *         return new AuthenticationKeyBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of AuthenticationKey, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see AuthenticationKey
 *
 */
@Generated("mdsal-binding-generator")
public class AuthenticationKeyBuilder {

    private Eid _eid;
    private EidUri _eidUri;
    private MappingAuthkey _mappingAuthkey;
    private AuthenticationKeyKey key;


    Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AuthenticationKeyBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link EidContainer}.
     *
     * @param arg EidContainer from which the builder should be initialized
     */
    public AuthenticationKeyBuilder(EidContainer arg) {
        this._eid = arg.getEid();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link MappingAuthkeyContainer}.
     *
     * @param arg MappingAuthkeyContainer from which the builder should be initialized
     */
    public AuthenticationKeyBuilder(MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link AuthenticationKey}.
     *
     * @param base AuthenticationKey from which the builder should be initialized
     */
    public AuthenticationKeyBuilder(AuthenticationKey base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._eidUri = base.getEidUri();
        this._eid = base.getEid();
        this._mappingAuthkey = base.getMappingAuthkey();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link EidContainer}</li>
     *   <li>{@link MappingAuthkeyContainer}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EidContainer castArg) {
            this._eid = castArg.getEid();
            isValidArg = true;
        }
        if (arg instanceof MappingAuthkeyContainer castArg) {
            this._mappingAuthkey = castArg.getMappingAuthkey();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EidContainer, MappingAuthkeyContainer]");
    }


    /**
     * Return current value associated with the property corresponding to {@link AuthenticationKey#key()}.
     *
     * @return current value
     */
    public AuthenticationKeyKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AuthenticationKey#getEid()}.
     *
     * @return current value
     */
    public Eid getEid() {
        return _eid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AuthenticationKey#getEidUri()}.
     *
     * @return current value
     */
    public EidUri getEidUri() {
        return _eidUri;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link AuthenticationKey#getMappingAuthkey()}.
     *
     * @return current value
     */
    public MappingAuthkey getMappingAuthkey() {
        return _mappingAuthkey;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AuthenticationKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link AuthenticationKey#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public AuthenticationKeyBuilder withKey(final AuthenticationKeyKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AuthenticationKey#getEid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AuthenticationKeyBuilder setEid(final Eid value) {
        this._eid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AuthenticationKey#getEidUri()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AuthenticationKeyBuilder setEidUri(final EidUri value) {
        this._eidUri = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link AuthenticationKey#getMappingAuthkey()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AuthenticationKeyBuilder setMappingAuthkey(final MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AuthenticationKeyBuilder addAugmentation(Augmentation<AuthenticationKey> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AuthenticationKeyBuilder removeAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link AuthenticationKey} instance.
     *
     * @return A new {@link AuthenticationKey} instance.
     */
    public @NonNull AuthenticationKey build() {
        return new AuthenticationKeyImpl(this);
    }

    private static final class AuthenticationKeyImpl
        extends AbstractAugmentable<AuthenticationKey>
        implements AuthenticationKey {
    
        private final Eid _eid;
        private final EidUri _eidUri;
        private final MappingAuthkey _mappingAuthkey;
        private final AuthenticationKeyKey key;
    
        AuthenticationKeyImpl(AuthenticationKeyBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new AuthenticationKeyKey(base.getEidUri());
            }
            this._eidUri = key.getEidUri();
            this._eid = base.getEid();
            this._mappingAuthkey = base.getMappingAuthkey();
        }
    
        @Override
        public AuthenticationKeyKey key() {
            return key;
        }
        
        @Override
        public Eid getEid() {
            return _eid;
        }
        
        @Override
        public EidUri getEidUri() {
            return _eidUri;
        }
        
        @Override
        public MappingAuthkey getMappingAuthkey() {
            return _mappingAuthkey;
        }
    
        @Override
        public Eid nonnullEid() {
            return Objects.requireNonNullElse(getEid(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.EidBuilder.empty());
        }
        
        
        @Override
        public MappingAuthkey nonnullMappingAuthkey() {
            return Objects.requireNonNullElse(getMappingAuthkey(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkeyBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = AuthenticationKey.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return AuthenticationKey.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return AuthenticationKey.bindingToString(this);
        }
    }
}
