package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link AuthenticationKey} class.
 *
 * @see AuthenticationKey
 *
 */
@Generated("mdsal-binding-generator")
public class AuthenticationKeyKey
 implements Identifier<AuthenticationKey> {
    @java.io.Serial
    private static final long serialVersionUID = 1037997786839588133L;
    private final EidUri _eidUri;


    /**
     * Constructs an instance.
     *
     * @param _eidUri the entity eidUri
     * @throws NullPointerException if any of the arguments are null
     */
    public AuthenticationKeyKey(@NonNull EidUri _eidUri) {
        this._eidUri = CodeHelpers.requireKeyProp(_eidUri, "eidUri");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public AuthenticationKeyKey(AuthenticationKeyKey source) {
        this._eidUri = source._eidUri;
    }


    /**
     * Return eidUri, guaranteed to be non-null.
     *
     * @return {@code EidUri} eidUri, guaranteed to be non-null.
     */
    public @NonNull EidUri getEidUri() {
        return _eidUri;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_eidUri);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof AuthenticationKeyKey other
            && Objects.equals(_eidUri, other._eidUri);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(AuthenticationKeyKey.class);
        CodeHelpers.appendValue(helper, "eidUri", _eidUri);
        return helper.toString();
    }
}

