package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMappingKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A list of EID-to-RLOC mappings within the same Instance ID
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list mapping {
 *   key "eid-uri origin";
 *   ext:context-instance eid-context;
 *   leaf eid-uri {
 *     type eid-uri;
 *   }
 *   leaf origin {
 *     type mapping-origin;
 *   }
 *   leaf-list site-id {
 *     type lisp-proto:site-id;
 *   }
 *   uses lisp-proto:mapping-record-container;
 *   list xtr-id-mapping {
 *     config false;
 *     key xtr-id-uri;
 *     ext:context-instance xtrid-context;
 *     leaf xtr-id-uri {
 *       type xtr-id-uri;
 *     }
 *     uses lisp-proto:mapping-record-container;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link MappingBuilder}.
 * @see MappingBuilder
 * @see MappingKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Mapping
    extends
    ChildOf<DbInstance>,
    Augmentable<Mapping>,
    MappingRecordContainer,
    Identifiable<MappingKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("mapping");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.@NonNull Mapping obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getEidUri());
        result = prime * result + Objects.hashCode(obj.getMappingRecord());
        result = prime * result + Objects.hashCode(obj.getOrigin());
        result = prime * result + Objects.hashCode(obj.getSiteId());
        result = prime * result + Objects.hashCode(obj.getXtrIdMapping());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.@NonNull Mapping thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping.class, obj);
        return other != null
            && Objects.equals(thisObj.getEidUri(), other.getEidUri())
            && Objects.equals(thisObj.getMappingRecord(), other.getMappingRecord())
            && Objects.equals(thisObj.getOrigin(), other.getOrigin())
            && Objects.equals(thisObj.getSiteId(), other.getSiteId())
            && Objects.equals(thisObj.getXtrIdMapping(), other.getXtrIdMapping())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.@NonNull Mapping obj) {
        final var helper = MoreObjects.toStringHelper("Mapping");
        CodeHelpers.appendValue(helper, "eidUri", obj.getEidUri());
        CodeHelpers.appendValue(helper, "mappingRecord", obj.getMappingRecord());
        CodeHelpers.appendValue(helper, "origin", obj.getOrigin());
        CodeHelpers.appendValue(helper, "siteId", obj.getSiteId());
        CodeHelpers.appendValue(helper, "xtrIdMapping", obj.getXtrIdMapping());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    MappingKey key();
    
    /**
     * Return eidUri, or {@code null} if it is not present.
     *
     * @return {@code EidUri} eidUri, or {@code null} if it is not present.
     *
     */
    EidUri getEidUri();
    
    /**
     * Return eidUri, guaranteed to be non-null.
     *
     * @return {@code EidUri} eidUri, guaranteed to be non-null.
     * @throws NoSuchElementException if eidUri is not present
     *
     */
    default @NonNull EidUri requireEidUri() {
        return CodeHelpers.require(getEidUri(), "eiduri");
    }
    
    /**
     * Return origin, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Mapping origin
     *     </code>
     * </pre>
     *
     * @return {@code MappingOrigin} origin, or {@code null} if it is not present.
     *
     */
    MappingOrigin getOrigin();
    
    /**
     * Return origin, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Mapping origin
     *     </code>
     * </pre>
     *
     * @return {@code MappingOrigin} origin, guaranteed to be non-null.
     * @throws NoSuchElementException if origin is not present
     *
     */
    default @NonNull MappingOrigin requireOrigin() {
        return CodeHelpers.require(getOrigin(), "origin");
    }
    
    /**
     * Return siteId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Site ID
     *     </code>
     * </pre>
     *
     * @return {@code Set<SiteId>} siteId, or {@code null} if it is not present.
     *
     */
    @Nullable Set<SiteId> getSiteId();
    
    /**
     * Return siteId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Site ID
     *     </code>
     * </pre>
     *
     * @return {@code Set<SiteId>} siteId, guaranteed to be non-null.
     * @throws NoSuchElementException if siteId is not present
     *
     */
    default @NonNull Set<SiteId> requireSiteId() {
        return CodeHelpers.require(getSiteId(), "siteid");
    }
    
    /**
     * Return xtrIdMapping, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A list of xTR-IDs with their associated mappings
     *     </code>
     * </pre>
     *
     * @return {@code Map<XtrIdMappingKey, XtrIdMapping>} xtrIdMapping, or {@code null} if it is not present.
     *
     */
    @Nullable Map<XtrIdMappingKey, XtrIdMapping> getXtrIdMapping();
    
    /**
     * Return xtrIdMapping, or an empty list if it is not present.
     *
     * @return {@code Map<XtrIdMappingKey, XtrIdMapping>} xtrIdMapping, or an empty list if it is not present.
     *
     */
    default @NonNull Map<XtrIdMappingKey, XtrIdMapping> nonnullXtrIdMapping() {
        return CodeHelpers.nonnull(getXtrIdMapping());
    }

}

