package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMappingKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Mapping} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Mapping createMapping(int fooXyzzy, int barBaz) {
 *         return new MappingBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Mapping, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Mapping
 *
 */
@Generated("mdsal-binding-generator")
public class MappingBuilder {

    private EidUri _eidUri;
    private MappingRecord _mappingRecord;
    private MappingOrigin _origin;
    private Set<SiteId> _siteId;
    private Map<XtrIdMappingKey, XtrIdMapping> _xtrIdMapping;
    private MappingKey key;


    Map<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public MappingBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link MappingRecordContainer}.
     *
     * @param arg MappingRecordContainer from which the builder should be initialized
     */
    public MappingBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Mapping}.
     *
     * @param base Mapping from which the builder should be initialized
     */
    public MappingBuilder(Mapping base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._eidUri = base.getEidUri();
        this._origin = base.getOrigin();
        this._mappingRecord = base.getMappingRecord();
        this._siteId = base.getSiteId();
        this._xtrIdMapping = base.getXtrIdMapping();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link MappingRecordContainer}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordContainer castArg) {
            this._mappingRecord = castArg.getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MappingRecordContainer]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Mapping#key()}.
     *
     * @return current value
     */
    public MappingKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Mapping#getEidUri()}.
     *
     * @return current value
     */
    public EidUri getEidUri() {
        return _eidUri;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Mapping#getMappingRecord()}.
     *
     * @return current value
     */
    public MappingRecord getMappingRecord() {
        return _mappingRecord;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Mapping#getOrigin()}.
     *
     * @return current value
     */
    public MappingOrigin getOrigin() {
        return _origin;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Mapping#getSiteId()}.
     *
     * @return current value
     */
    public Set<SiteId> getSiteId() {
        return _siteId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Mapping#getXtrIdMapping()}.
     *
     * @return current value
     */
    public Map<XtrIdMappingKey, XtrIdMapping> getXtrIdMapping() {
        return _xtrIdMapping;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Mapping>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Mapping#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public MappingBuilder withKey(final MappingKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Mapping#getEidUri()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MappingBuilder setEidUri(final EidUri value) {
        this._eidUri = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Mapping#getMappingRecord()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MappingBuilder setMappingRecord(final MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Mapping#getOrigin()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public MappingBuilder setOrigin(final MappingOrigin value) {
        this._origin = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Mapping#getSiteId()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public MappingBuilder setSiteId(final Set<SiteId> values) {
        this._siteId = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Mapping#getXtrIdMapping()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public MappingBuilder setXtrIdMapping(final Map<XtrIdMappingKey, XtrIdMapping> values) {
        this._xtrIdMapping = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MappingBuilder addAugmentation(Augmentation<Mapping> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MappingBuilder removeAugmentation(Class<? extends Augmentation<Mapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Mapping} instance.
     *
     * @return A new {@link Mapping} instance.
     */
    public @NonNull Mapping build() {
        return new MappingImpl(this);
    }

    private static final class MappingImpl
        extends AbstractAugmentable<Mapping>
        implements Mapping {
    
        private final EidUri _eidUri;
        private final MappingRecord _mappingRecord;
        private final MappingOrigin _origin;
        private final Set<SiteId> _siteId;
        private final Map<XtrIdMappingKey, XtrIdMapping> _xtrIdMapping;
        private final MappingKey key;
    
        MappingImpl(MappingBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new MappingKey(base.getEidUri(), base.getOrigin());
            }
            this._eidUri = key.getEidUri();
            this._origin = key.getOrigin();
            this._mappingRecord = base.getMappingRecord();
            this._siteId = base.getSiteId();
            this._xtrIdMapping = CodeHelpers.emptyToNull(base.getXtrIdMapping());
        }
    
        @Override
        public MappingKey key() {
            return key;
        }
        
        @Override
        public EidUri getEidUri() {
            return _eidUri;
        }
        
        @Override
        public MappingRecord getMappingRecord() {
            return _mappingRecord;
        }
        
        @Override
        public MappingOrigin getOrigin() {
            return _origin;
        }
        
        @Override
        public Set<SiteId> getSiteId() {
            return _siteId;
        }
        
        @Override
        public Map<XtrIdMappingKey, XtrIdMapping> getXtrIdMapping() {
            return _xtrIdMapping;
        }
    
        
        @Override
        public MappingRecord nonnullMappingRecord() {
            return Objects.requireNonNullElse(getMappingRecord(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecordBuilder.empty());
        }
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Mapping.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Mapping.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Mapping.bindingToString(this);
        }
    }
}
