package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Mapping} class.
 *
 * @see Mapping
 *
 */
@Generated("mdsal-binding-generator")
public class MappingKey
 implements Identifier<Mapping> {
    @java.io.Serial
    private static final long serialVersionUID = -3556653507644188538L;
    private final EidUri _eidUri;
    private final MappingOrigin _origin;


    /**
     * Constructs an instance.
     *
     * @param _eidUri the entity eidUri
     * @param _origin the entity origin
     * @throws NullPointerException if any of the arguments are null
     */
    public MappingKey(@NonNull EidUri _eidUri, @NonNull MappingOrigin _origin) {
        this._eidUri = CodeHelpers.requireKeyProp(_eidUri, "eidUri");
        this._origin = CodeHelpers.requireKeyProp(_origin, "origin");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MappingKey(MappingKey source) {
        this._eidUri = source._eidUri;
        this._origin = source._origin;
    }


    /**
     * Return eidUri, guaranteed to be non-null.
     *
     * @return {@code EidUri} eidUri, guaranteed to be non-null.
     */
    public @NonNull EidUri getEidUri() {
        return _eidUri;
    }
    
    /**
     * Return origin, guaranteed to be non-null.
     *
     * @return {@code MappingOrigin} origin, guaranteed to be non-null.
     */
    public @NonNull MappingOrigin getOrigin() {
        return _origin;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_eidUri);
        result = prime * result + Objects.hashCode(_origin);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof MappingKey other
            && Objects.equals(_eidUri, other._eidUri)        
            && Objects.equals(_origin, other._origin);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(MappingKey.class);
        CodeHelpers.appendValue(helper, "eidUri", _eidUri);
        CodeHelpers.appendValue(helper, "origin", _origin);
        return helper.toString();
    }
}

