package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * A list of xTR-IDs with their associated mappings
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list xtr-id-mapping {
 *   config false;
 *   key xtr-id-uri;
 *   ext:context-instance xtrid-context;
 *   leaf xtr-id-uri {
 *     type xtr-id-uri;
 *   }
 *   uses lisp-proto:mapping-record-container;
 * }
 * </pre>
 * <p>To create instances of this class use {@link XtrIdMappingBuilder}.
 * @see XtrIdMappingBuilder
 * @see XtrIdMappingKey
 *
 */
@Generated("mdsal-binding-generator")
public interface XtrIdMapping
    extends
    ChildOf<Mapping>,
    Augmentable<XtrIdMapping>,
    MappingRecordContainer,
    Identifiable<XtrIdMappingKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("xtr-id-mapping");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.@NonNull XtrIdMapping obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMappingRecord());
        result = prime * result + Objects.hashCode(obj.getXtrIdUri());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.@NonNull XtrIdMapping thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping.class, obj);
        return other != null
            && Objects.equals(thisObj.getXtrIdUri(), other.getXtrIdUri())
            && Objects.equals(thisObj.getMappingRecord(), other.getMappingRecord())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.@NonNull XtrIdMapping obj) {
        final var helper = MoreObjects.toStringHelper("XtrIdMapping");
        CodeHelpers.appendValue(helper, "mappingRecord", obj.getMappingRecord());
        CodeHelpers.appendValue(helper, "xtrIdUri", obj.getXtrIdUri());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    XtrIdMappingKey key();
    
    /**
     * Return xtrIdUri, or {@code null} if it is not present.
     *
     * @return {@code XtrIdUri} xtrIdUri, or {@code null} if it is not present.
     *
     */
    XtrIdUri getXtrIdUri();
    
    /**
     * Return xtrIdUri, guaranteed to be non-null.
     *
     * @return {@code XtrIdUri} xtrIdUri, guaranteed to be non-null.
     * @throws NoSuchElementException if xtrIdUri is not present
     *
     */
    default @NonNull XtrIdUri requireXtrIdUri() {
        return CodeHelpers.require(getXtrIdUri(), "xtriduri");
    }

}

