package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link XtrIdMapping} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     XtrIdMapping createXtrIdMapping(int fooXyzzy, int barBaz) {
 *         return new XtrIdMappingBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of XtrIdMapping, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see XtrIdMapping
 *
 */
@Generated("mdsal-binding-generator")
public class XtrIdMappingBuilder {

    private MappingRecord _mappingRecord;
    private XtrIdUri _xtrIdUri;
    private XtrIdMappingKey key;


    Map<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public XtrIdMappingBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link MappingRecordContainer}.
     *
     * @param arg MappingRecordContainer from which the builder should be initialized
     */
    public XtrIdMappingBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link XtrIdMapping}.
     *
     * @param base XtrIdMapping from which the builder should be initialized
     */
    public XtrIdMappingBuilder(XtrIdMapping base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._xtrIdUri = base.getXtrIdUri();
        this._mappingRecord = base.getMappingRecord();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link MappingRecordContainer}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordContainer castArg) {
            this._mappingRecord = castArg.getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MappingRecordContainer]");
    }


    /**
     * Return current value associated with the property corresponding to {@link XtrIdMapping#key()}.
     *
     * @return current value
     */
    public XtrIdMappingKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link XtrIdMapping#getMappingRecord()}.
     *
     * @return current value
     */
    public MappingRecord getMappingRecord() {
        return _mappingRecord;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link XtrIdMapping#getXtrIdUri()}.
     *
     * @return current value
     */
    public XtrIdUri getXtrIdUri() {
        return _xtrIdUri;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<XtrIdMapping>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link XtrIdMapping#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public XtrIdMappingBuilder withKey(final XtrIdMappingKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link XtrIdMapping#getMappingRecord()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public XtrIdMappingBuilder setMappingRecord(final MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link XtrIdMapping#getXtrIdUri()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public XtrIdMappingBuilder setXtrIdUri(final XtrIdUri value) {
        this._xtrIdUri = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public XtrIdMappingBuilder addAugmentation(Augmentation<XtrIdMapping> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public XtrIdMappingBuilder removeAugmentation(Class<? extends Augmentation<XtrIdMapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link XtrIdMapping} instance.
     *
     * @return A new {@link XtrIdMapping} instance.
     */
    public @NonNull XtrIdMapping build() {
        return new XtrIdMappingImpl(this);
    }

    private static final class XtrIdMappingImpl
        extends AbstractAugmentable<XtrIdMapping>
        implements XtrIdMapping {
    
        private final MappingRecord _mappingRecord;
        private final XtrIdUri _xtrIdUri;
        private final XtrIdMappingKey key;
    
        XtrIdMappingImpl(XtrIdMappingBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new XtrIdMappingKey(base.getXtrIdUri());
            }
            this._xtrIdUri = key.getXtrIdUri();
            this._mappingRecord = base.getMappingRecord();
        }
    
        @Override
        public XtrIdMappingKey key() {
            return key;
        }
        
        @Override
        public MappingRecord getMappingRecord() {
            return _mappingRecord;
        }
        
        @Override
        public XtrIdUri getXtrIdUri() {
            return _xtrIdUri;
        }
    
        @Override
        public MappingRecord nonnullMappingRecord() {
            return Objects.requireNonNullElse(getMappingRecord(), org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecordBuilder.empty());
        }
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = XtrIdMapping.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return XtrIdMapping.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return XtrIdMapping.bindingToString(this);
        }
    }
}
