package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link XtrIdMapping} class.
 *
 * @see XtrIdMapping
 *
 */
@Generated("mdsal-binding-generator")
public class XtrIdMappingKey
 implements Identifier<XtrIdMapping> {
    @java.io.Serial
    private static final long serialVersionUID = -8832823683084686280L;
    private final XtrIdUri _xtrIdUri;


    /**
     * Constructs an instance.
     *
     * @param _xtrIdUri the entity xtrIdUri
     * @throws NullPointerException if any of the arguments are null
     */
    public XtrIdMappingKey(@NonNull XtrIdUri _xtrIdUri) {
        this._xtrIdUri = CodeHelpers.requireKeyProp(_xtrIdUri, "xtrIdUri");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public XtrIdMappingKey(XtrIdMappingKey source) {
        this._xtrIdUri = source._xtrIdUri;
    }


    /**
     * Return xtrIdUri, guaranteed to be non-null.
     *
     * @return {@code XtrIdUri} xtrIdUri, guaranteed to be non-null.
     */
    public @NonNull XtrIdUri getXtrIdUri() {
        return _xtrIdUri;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_xtrIdUri);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof XtrIdMappingKey other
            && Objects.equals(_xtrIdUri, other._xtrIdUri);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(XtrIdMappingKey.class);
        CodeHelpers.appendValue(helper, "xtrIdUri", _xtrIdUri);
        return helper.toString();
    }
}

