package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link MappingAuthkeyItem} class.
 *
 * @see MappingAuthkeyItem
 *
 */
@Generated("mdsal-binding-generator")
public class MappingAuthkeyItemKey
 implements Identifier<MappingAuthkeyItem> {
    @java.io.Serial
    private static final long serialVersionUID = -1218215823410352147L;
    private final String _mappingAuthkeyItemId;


    /**
     * Constructs an instance.
     *
     * @param _mappingAuthkeyItemId the entity mappingAuthkeyItemId
     * @throws NullPointerException if any of the arguments are null
     */
    public MappingAuthkeyItemKey(@NonNull String _mappingAuthkeyItemId) {
        this._mappingAuthkeyItemId = CodeHelpers.requireKeyProp(_mappingAuthkeyItemId, "mappingAuthkeyItemId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MappingAuthkeyItemKey(MappingAuthkeyItemKey source) {
        this._mappingAuthkeyItemId = source._mappingAuthkeyItemId;
    }


    /**
     * Return mappingAuthkeyItemId, guaranteed to be non-null.
     *
     * @return {@code String} mappingAuthkeyItemId, guaranteed to be non-null.
     */
    public @NonNull String getMappingAuthkeyItemId() {
        return _mappingAuthkeyItemId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_mappingAuthkeyItemId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof MappingAuthkeyItemKey other
            && Objects.equals(_mappingAuthkeyItemId, other._mappingAuthkeyItemId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(MappingAuthkeyItemKey.class);
        CodeHelpers.appendValue(helper, "mappingAuthkeyItemId", _mappingAuthkeyItemId);
        return helper.toString();
    }
}

