package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKeyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.MappingKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link VirtualNetworkIdentifier} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     VirtualNetworkIdentifier createVirtualNetworkIdentifier(int fooXyzzy, int barBaz) {
 *         return new VirtualNetworkIdentifierBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of VirtualNetworkIdentifier, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see VirtualNetworkIdentifier
 *
 */
@Generated("mdsal-binding-generator")
public class VirtualNetworkIdentifierBuilder {

    private Map<AuthenticationKeyKey, AuthenticationKey> _authenticationKey;
    private Map<MappingKey, Mapping> _mapping;
    private VniUri _vni;
    private VirtualNetworkIdentifierKey key;


    Map<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public VirtualNetworkIdentifierBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link DbInstance}.
     *
     * @param arg DbInstance from which the builder should be initialized
     */
    public VirtualNetworkIdentifierBuilder(DbInstance arg) {
        this._vni = arg.getVni();
        this._mapping = arg.getMapping();
        this._authenticationKey = arg.getAuthenticationKey();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link VirtualNetworkIdentifier}.
     *
     * @param base VirtualNetworkIdentifier from which the builder should be initialized
     */
    public VirtualNetworkIdentifierBuilder(VirtualNetworkIdentifier base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._vni = base.getVni();
        this._authenticationKey = base.getAuthenticationKey();
        this._mapping = base.getMapping();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link DbInstance}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DbInstance castArg) {
            this._vni = castArg.getVni();
            this._mapping = castArg.getMapping();
            this._authenticationKey = castArg.getAuthenticationKey();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[DbInstance]");
    }


    /**
     * Return current value associated with the property corresponding to {@link VirtualNetworkIdentifier#key()}.
     *
     * @return current value
     */
    public VirtualNetworkIdentifierKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link VirtualNetworkIdentifier#getAuthenticationKey()}.
     *
     * @return current value
     */
    public Map<AuthenticationKeyKey, AuthenticationKey> getAuthenticationKey() {
        return _authenticationKey;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link VirtualNetworkIdentifier#getMapping()}.
     *
     * @return current value
     */
    public Map<MappingKey, Mapping> getMapping() {
        return _mapping;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link VirtualNetworkIdentifier#getVni()}.
     *
     * @return current value
     */
    public VniUri getVni() {
        return _vni;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<VirtualNetworkIdentifier>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link VirtualNetworkIdentifier#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public VirtualNetworkIdentifierBuilder withKey(final VirtualNetworkIdentifierKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link VirtualNetworkIdentifier#getAuthenticationKey()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public VirtualNetworkIdentifierBuilder setAuthenticationKey(final Map<AuthenticationKeyKey, AuthenticationKey> values) {
        this._authenticationKey = values;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link VirtualNetworkIdentifier#getMapping()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public VirtualNetworkIdentifierBuilder setMapping(final Map<MappingKey, Mapping> values) {
        this._mapping = values;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link VirtualNetworkIdentifier#getVni()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public VirtualNetworkIdentifierBuilder setVni(final VniUri value) {
        this._vni = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public VirtualNetworkIdentifierBuilder addAugmentation(Augmentation<VirtualNetworkIdentifier> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public VirtualNetworkIdentifierBuilder removeAugmentation(Class<? extends Augmentation<VirtualNetworkIdentifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link VirtualNetworkIdentifier} instance.
     *
     * @return A new {@link VirtualNetworkIdentifier} instance.
     */
    public @NonNull VirtualNetworkIdentifier build() {
        return new VirtualNetworkIdentifierImpl(this);
    }

    private static final class VirtualNetworkIdentifierImpl
        extends AbstractAugmentable<VirtualNetworkIdentifier>
        implements VirtualNetworkIdentifier {
    
        private final Map<AuthenticationKeyKey, AuthenticationKey> _authenticationKey;
        private final Map<MappingKey, Mapping> _mapping;
        private final VniUri _vni;
        private final VirtualNetworkIdentifierKey key;
    
        VirtualNetworkIdentifierImpl(VirtualNetworkIdentifierBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new VirtualNetworkIdentifierKey(base.getVni());
            }
            this._vni = key.getVni();
            this._authenticationKey = CodeHelpers.emptyToNull(base.getAuthenticationKey());
            this._mapping = CodeHelpers.emptyToNull(base.getMapping());
        }
    
        @Override
        public VirtualNetworkIdentifierKey key() {
            return key;
        }
        
        @Override
        public Map<AuthenticationKeyKey, AuthenticationKey> getAuthenticationKey() {
            return _authenticationKey;
        }
        
        @Override
        public Map<MappingKey, Mapping> getMapping() {
            return _mapping;
        }
        
        @Override
        public VniUri getVni() {
            return _vni;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = VirtualNetworkIdentifier.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return VirtualNetworkIdentifier.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return VirtualNetworkIdentifier.bindingToString(this);
        }
    }
}
