package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link VirtualNetworkIdentifier} class.
 *
 * @see VirtualNetworkIdentifier
 *
 */
@Generated("mdsal-binding-generator")
public class VirtualNetworkIdentifierKey
 implements Identifier<VirtualNetworkIdentifier> {
    @java.io.Serial
    private static final long serialVersionUID = -3933872609824293399L;
    private final VniUri _vni;


    /**
     * Constructs an instance.
     *
     * @param _vni the entity vni
     * @throws NullPointerException if any of the arguments are null
     */
    public VirtualNetworkIdentifierKey(@NonNull VniUri _vni) {
        this._vni = CodeHelpers.requireKeyProp(_vni, "vni");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public VirtualNetworkIdentifierKey(VirtualNetworkIdentifierKey source) {
        this._vni = source._vni;
    }


    /**
     * Return vni, guaranteed to be non-null.
     *
     * @return {@code VniUri} vni, guaranteed to be non-null.
     */
    public @NonNull VniUri getVni() {
        return _vni;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_vni);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof VirtualNetworkIdentifierKey other
            && Objects.equals(_vni, other._vni);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(VirtualNetworkIdentifierKey.class);
        CodeHelpers.appendValue(helper, "vni", _vni);
        return helper.toString();
    }
}

