/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.EidBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecordBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChange;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.DstSubscriberItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.SubscriberItem;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingChangedBuilder {
    private MappingChange _changeType;
    private List<DstSubscriberItem> _dstSubscriberItem;
    private Eid _eid;
    private MappingRecord _mappingRecord;
    private List<SubscriberItem> _subscriberItem;
    Map<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> augmentation = Map.of();

    public MappingChangedBuilder() {
    }

    public MappingChangedBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingChangedBuilder(EidContainer arg) {
        this._eid = arg.getEid();
    }

    public MappingChangedBuilder(MappingChanged base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>>(aug);
        }
        this._changeType = base.getChangeType();
        this._dstSubscriberItem = base.getDstSubscriberItem();
        this._eid = base.getEid();
        this._mappingRecord = base.getMappingRecord();
        this._subscriberItem = base.getSubscriberItem();
    }

    public void fieldsFrom(DataObject arg) {
        EidContainer castArg;
        boolean isValidArg = false;
        if (arg instanceof EidContainer) {
            castArg = (EidContainer)arg;
            this._eid = castArg.getEid();
            isValidArg = true;
        }
        if (arg instanceof MappingRecordContainer) {
            castArg = (MappingRecordContainer)arg;
            this._mappingRecord = castArg.getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[EidContainer, MappingRecordContainer]");
    }

    public MappingChange getChangeType() {
        return this._changeType;
    }

    public List<DstSubscriberItem> getDstSubscriberItem() {
        return this._dstSubscriberItem;
    }

    public Eid getEid() {
        return this._eid;
    }

    public MappingRecord getMappingRecord() {
        return this._mappingRecord;
    }

    public List<SubscriberItem> getSubscriberItem() {
        return this._subscriberItem;
    }

    public <E$$ extends Augmentation<MappingChanged>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MappingChangedBuilder setChangeType(MappingChange value) {
        this._changeType = value;
        return this;
    }

    public MappingChangedBuilder setDstSubscriberItem(List<DstSubscriberItem> values) {
        this._dstSubscriberItem = values;
        return this;
    }

    public MappingChangedBuilder setEid(Eid value) {
        this._eid = value;
        return this;
    }

    public MappingChangedBuilder setMappingRecord(MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }

    public MappingChangedBuilder setSubscriberItem(List<SubscriberItem> values) {
        this._subscriberItem = values;
        return this;
    }

    public MappingChangedBuilder addAugmentation(Augmentation<MappingChanged> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MappingChangedBuilder removeAugmentation(Class<? extends Augmentation<MappingChanged>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MappingChanged build() {
        return new MappingChangedImpl(this);
    }

    private static final class MappingChangedImpl
    extends AbstractAugmentable<MappingChanged>
    implements MappingChanged {
        private final MappingChange _changeType;
        private final List<DstSubscriberItem> _dstSubscriberItem;
        private final Eid _eid;
        private final MappingRecord _mappingRecord;
        private final List<SubscriberItem> _subscriberItem;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MappingChangedImpl(MappingChangedBuilder base) {
            super(base.augmentation);
            this._changeType = base.getChangeType();
            this._dstSubscriberItem = CodeHelpers.emptyToNull(base.getDstSubscriberItem());
            this._eid = base.getEid();
            this._mappingRecord = base.getMappingRecord();
            this._subscriberItem = CodeHelpers.emptyToNull(base.getSubscriberItem());
        }

        @Override
        public MappingChange getChangeType() {
            return this._changeType;
        }

        @Override
        public List<DstSubscriberItem> getDstSubscriberItem() {
            return this._dstSubscriberItem;
        }

        public Eid getEid() {
            return this._eid;
        }

        public MappingRecord getMappingRecord() {
            return this._mappingRecord;
        }

        @Override
        public List<SubscriberItem> getSubscriberItem() {
            return this._subscriberItem;
        }

        public Eid nonnullEid() {
            return Objects.requireNonNullElse(this.getEid(), EidBuilder.empty());
        }

        public MappingRecord nonnullMappingRecord() {
            return Objects.requireNonNullElse(this.getMappingRecord(), MappingRecordBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MappingChanged.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MappingChanged.bindingEquals(this, obj);
        }

        public String toString() {
            return MappingChanged.bindingToString(this);
        }
    }
}

