/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.EidBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkeyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKeyKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AuthenticationKeyBuilder {
    private Eid _eid;
    private EidUri _eidUri;
    private MappingAuthkey _mappingAuthkey;
    private AuthenticationKeyKey key;
    Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> augmentation = Map.of();

    public AuthenticationKeyBuilder() {
    }

    public AuthenticationKeyBuilder(EidContainer arg) {
        this._eid = arg.getEid();
    }

    public AuthenticationKeyBuilder(MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }

    public AuthenticationKeyBuilder(AuthenticationKey base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>(aug);
        }
        this.key = base.key();
        this._eidUri = base.getEidUri();
        this._eid = base.getEid();
        this._mappingAuthkey = base.getMappingAuthkey();
    }

    public void fieldsFrom(DataObject arg) {
        EidContainer castArg;
        boolean isValidArg = false;
        if (arg instanceof EidContainer) {
            castArg = (EidContainer)arg;
            this._eid = castArg.getEid();
            isValidArg = true;
        }
        if (arg instanceof MappingAuthkeyContainer) {
            castArg = (MappingAuthkeyContainer)arg;
            this._mappingAuthkey = castArg.getMappingAuthkey();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[EidContainer, MappingAuthkeyContainer]");
    }

    public AuthenticationKeyKey key() {
        return this.key;
    }

    public Eid getEid() {
        return this._eid;
    }

    public EidUri getEidUri() {
        return this._eidUri;
    }

    public MappingAuthkey getMappingAuthkey() {
        return this._mappingAuthkey;
    }

    public <E$$ extends Augmentation<AuthenticationKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AuthenticationKeyBuilder withKey(AuthenticationKeyKey key) {
        this.key = key;
        return this;
    }

    public AuthenticationKeyBuilder setEid(Eid value) {
        this._eid = value;
        return this;
    }

    public AuthenticationKeyBuilder setEidUri(EidUri value) {
        this._eidUri = value;
        return this;
    }

    public AuthenticationKeyBuilder setMappingAuthkey(MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }

    public AuthenticationKeyBuilder addAugmentation(Augmentation<AuthenticationKey> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public AuthenticationKeyBuilder removeAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull AuthenticationKey build() {
        return new AuthenticationKeyImpl(this);
    }

    private static final class AuthenticationKeyImpl
    extends AbstractAugmentable<AuthenticationKey>
    implements AuthenticationKey {
        private final Eid _eid;
        private final EidUri _eidUri;
        private final MappingAuthkey _mappingAuthkey;
        private final AuthenticationKeyKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AuthenticationKeyImpl(AuthenticationKeyBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new AuthenticationKeyKey(base.getEidUri());
            this._eidUri = this.key.getEidUri();
            this._eid = base.getEid();
            this._mappingAuthkey = base.getMappingAuthkey();
        }

        @Override
        public AuthenticationKeyKey key() {
            return this.key;
        }

        public Eid getEid() {
            return this._eid;
        }

        @Override
        public EidUri getEidUri() {
            return this._eidUri;
        }

        public MappingAuthkey getMappingAuthkey() {
            return this._mappingAuthkey;
        }

        public Eid nonnullEid() {
            return Objects.requireNonNullElse(this.getEid(), EidBuilder.empty());
        }

        public MappingAuthkey nonnullMappingAuthkey() {
            return Objects.requireNonNullElse(this.getMappingAuthkey(), MappingAuthkeyBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = AuthenticationKey.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return AuthenticationKey.bindingEquals(this, obj);
        }

        public String toString() {
            return AuthenticationKey.bindingToString(this);
        }
    }
}

