/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecordBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.MappingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMappingKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingBuilder {
    private EidUri _eidUri;
    private MappingRecord _mappingRecord;
    private MappingOrigin _origin;
    private Set<SiteId> _siteId;
    private Map<XtrIdMappingKey, XtrIdMapping> _xtrIdMapping;
    private MappingKey key;
    Map<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> augmentation = Map.of();

    public MappingBuilder() {
    }

    public MappingBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingBuilder(Mapping base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>>(aug);
        }
        this.key = base.key();
        this._eidUri = base.getEidUri();
        this._origin = base.getOrigin();
        this._mappingRecord = base.getMappingRecord();
        this._siteId = base.getSiteId();
        this._xtrIdMapping = base.getXtrIdMapping();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordContainer) {
            MappingRecordContainer castArg = (MappingRecordContainer)arg;
            this._mappingRecord = castArg.getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[MappingRecordContainer]");
    }

    public MappingKey key() {
        return this.key;
    }

    public EidUri getEidUri() {
        return this._eidUri;
    }

    public MappingRecord getMappingRecord() {
        return this._mappingRecord;
    }

    public MappingOrigin getOrigin() {
        return this._origin;
    }

    public Set<SiteId> getSiteId() {
        return this._siteId;
    }

    public Map<XtrIdMappingKey, XtrIdMapping> getXtrIdMapping() {
        return this._xtrIdMapping;
    }

    public <E$$ extends Augmentation<Mapping>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MappingBuilder withKey(MappingKey key) {
        this.key = key;
        return this;
    }

    public MappingBuilder setEidUri(EidUri value) {
        this._eidUri = value;
        return this;
    }

    public MappingBuilder setMappingRecord(MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }

    public MappingBuilder setOrigin(MappingOrigin value) {
        this._origin = value;
        return this;
    }

    public MappingBuilder setSiteId(Set<SiteId> values) {
        this._siteId = values;
        return this;
    }

    public MappingBuilder setXtrIdMapping(Map<XtrIdMappingKey, XtrIdMapping> values) {
        this._xtrIdMapping = values;
        return this;
    }

    public MappingBuilder addAugmentation(Augmentation<Mapping> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MappingBuilder removeAugmentation(Class<? extends Augmentation<Mapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Mapping build() {
        return new MappingImpl(this);
    }

    private static final class MappingImpl
    extends AbstractAugmentable<Mapping>
    implements Mapping {
        private final EidUri _eidUri;
        private final MappingRecord _mappingRecord;
        private final MappingOrigin _origin;
        private final Set<SiteId> _siteId;
        private final Map<XtrIdMappingKey, XtrIdMapping> _xtrIdMapping;
        private final MappingKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MappingImpl(MappingBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new MappingKey(base.getEidUri(), base.getOrigin());
            this._eidUri = this.key.getEidUri();
            this._origin = this.key.getOrigin();
            this._mappingRecord = base.getMappingRecord();
            this._siteId = base.getSiteId();
            this._xtrIdMapping = CodeHelpers.emptyToNull(base.getXtrIdMapping());
        }

        @Override
        public MappingKey key() {
            return this.key;
        }

        @Override
        public EidUri getEidUri() {
            return this._eidUri;
        }

        public MappingRecord getMappingRecord() {
            return this._mappingRecord;
        }

        @Override
        public MappingOrigin getOrigin() {
            return this._origin;
        }

        @Override
        public Set<SiteId> getSiteId() {
            return this._siteId;
        }

        @Override
        public Map<XtrIdMappingKey, XtrIdMapping> getXtrIdMapping() {
            return this._xtrIdMapping;
        }

        public MappingRecord nonnullMappingRecord() {
            return Objects.requireNonNullElse(this.getMappingRecord(), MappingRecordBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Mapping.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Mapping.bindingEquals(this, obj);
        }

        public String toString() {
            return Mapping.bindingToString(this);
        }
    }
}

