/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping._record.container.MappingRecordBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMappingKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class XtrIdMappingBuilder {
    private MappingRecord _mappingRecord;
    private XtrIdUri _xtrIdUri;
    private XtrIdMappingKey key;
    Map<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> augmentation = Map.of();

    public XtrIdMappingBuilder() {
    }

    public XtrIdMappingBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public XtrIdMappingBuilder(XtrIdMapping base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>>(aug);
        }
        this.key = base.key();
        this._xtrIdUri = base.getXtrIdUri();
        this._mappingRecord = base.getMappingRecord();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordContainer) {
            MappingRecordContainer castArg = (MappingRecordContainer)arg;
            this._mappingRecord = castArg.getMappingRecord();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[MappingRecordContainer]");
    }

    public XtrIdMappingKey key() {
        return this.key;
    }

    public MappingRecord getMappingRecord() {
        return this._mappingRecord;
    }

    public XtrIdUri getXtrIdUri() {
        return this._xtrIdUri;
    }

    public <E$$ extends Augmentation<XtrIdMapping>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public XtrIdMappingBuilder withKey(XtrIdMappingKey key) {
        this.key = key;
        return this;
    }

    public XtrIdMappingBuilder setMappingRecord(MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }

    public XtrIdMappingBuilder setXtrIdUri(XtrIdUri value) {
        this._xtrIdUri = value;
        return this;
    }

    public XtrIdMappingBuilder addAugmentation(Augmentation<XtrIdMapping> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public XtrIdMappingBuilder removeAugmentation(Class<? extends Augmentation<XtrIdMapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull XtrIdMapping build() {
        return new XtrIdMappingImpl(this);
    }

    private static final class XtrIdMappingImpl
    extends AbstractAugmentable<XtrIdMapping>
    implements XtrIdMapping {
        private final MappingRecord _mappingRecord;
        private final XtrIdUri _xtrIdUri;
        private final XtrIdMappingKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        XtrIdMappingImpl(XtrIdMappingBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new XtrIdMappingKey(base.getXtrIdUri());
            this._xtrIdUri = this.key.getXtrIdUri();
            this._mappingRecord = base.getMappingRecord();
        }

        @Override
        public XtrIdMappingKey key() {
            return this.key;
        }

        public MappingRecord getMappingRecord() {
            return this._mappingRecord;
        }

        @Override
        public XtrIdUri getXtrIdUri() {
            return this._xtrIdUri;
        }

        public MappingRecord nonnullMappingRecord() {
            return Objects.requireNonNullElse(this.getMappingRecord(), MappingRecordBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = XtrIdMapping.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return XtrIdMapping.bindingEquals(this, obj);
        }

        public String toString() {
            return XtrIdMapping.bindingToString(this);
        }
    }
}

