/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMappingKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class XtrIdMappingBuilder
implements Builder<XtrIdMapping> {
    private XtrIdMappingKey _key;
    private MappingRecord _mappingRecord;
    private XtrIdUri _xtrIdUri;
    Map<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> augmentation = Collections.emptyMap();

    public XtrIdMappingBuilder() {
    }

    public XtrIdMappingBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public XtrIdMappingBuilder(XtrIdMapping base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new XtrIdMappingKey(base.getXtrIdUri());
            this._xtrIdUri = base.getXtrIdUri();
        } else {
            this._key = base.getKey();
            this._xtrIdUri = this._key.getXtrIdUri();
        }
        this._mappingRecord = base.getMappingRecord();
        if (base instanceof XtrIdMappingImpl) {
            XtrIdMappingImpl impl = (XtrIdMappingImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordContainer) {
            this._mappingRecord = ((MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer] \nbut was: " + arg);
        }
    }

    public XtrIdMappingKey getKey() {
        return this._key;
    }

    public MappingRecord getMappingRecord() {
        return this._mappingRecord;
    }

    public XtrIdUri getXtrIdUri() {
        return this._xtrIdUri;
    }

    public <E extends Augmentation<XtrIdMapping>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public XtrIdMappingBuilder setKey(XtrIdMappingKey value) {
        this._key = value;
        return this;
    }

    public XtrIdMappingBuilder setMappingRecord(MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }

    public XtrIdMappingBuilder setXtrIdUri(XtrIdUri value) {
        this._xtrIdUri = value;
        return this;
    }

    public XtrIdMappingBuilder addAugmentation(Class<? extends Augmentation<XtrIdMapping>> augmentationType, Augmentation<XtrIdMapping> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public XtrIdMappingBuilder removeAugmentation(Class<? extends Augmentation<XtrIdMapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public XtrIdMapping build() {
        return new XtrIdMappingImpl(this);
    }

    private static final class XtrIdMappingImpl
    implements XtrIdMapping {
        private final XtrIdMappingKey _key;
        private final MappingRecord _mappingRecord;
        private final XtrIdUri _xtrIdUri;
        private Map<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<XtrIdMapping> getImplementedInterface() {
            return XtrIdMapping.class;
        }

        private XtrIdMappingImpl(XtrIdMappingBuilder base) {
            if (base.getKey() == null) {
                this._key = new XtrIdMappingKey(base.getXtrIdUri());
                this._xtrIdUri = base.getXtrIdUri();
            } else {
                this._key = base.getKey();
                this._xtrIdUri = this._key.getXtrIdUri();
            }
            this._mappingRecord = base.getMappingRecord();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>>(base.augmentation);
                }
            }
        }

        @Override
        public XtrIdMappingKey getKey() {
            return this._key;
        }

        public MappingRecord getMappingRecord() {
            return this._mappingRecord;
        }

        @Override
        public XtrIdUri getXtrIdUri() {
            return this._xtrIdUri;
        }

        public <E extends Augmentation<XtrIdMapping>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._mappingRecord);
            result = 31 * result + Objects.hashCode(this._xtrIdUri);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!XtrIdMapping.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            XtrIdMapping other = (XtrIdMapping)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals(this._xtrIdUri, other.getXtrIdUri())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                XtrIdMappingImpl otherImpl = (XtrIdMappingImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<XtrIdMapping>>, Augmentation<XtrIdMapping>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "XtrIdMapping [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._mappingRecord != null) {
                builder.append("_mappingRecord=");
                builder.append(this._mappingRecord);
                builder.append(", ");
            }
            if (this._xtrIdUri != null) {
                builder.append("_xtrIdUri=");
                builder.append(this._xtrIdUri);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

