/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.lispflowmapping.interfaces.dao;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.rloc.container.Rloc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.subscriber.data.grouping.SubscriberData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.subscriber.data.grouping.SubscriberDataBuilder;

public class Subscriber {
    public static final int DEFAULT_SUBSCRIBER_TIMEOUT = (int)TimeUnit.DAYS.toMinutes(1L);
    private static final int SUBSCRIBER_TIMEOUT_CONSTANT = 10;
    private SubscriberData data;
    private Date lastRequestDate;

    public Subscriber(SubscriberData subscriberData) {
        this.data = subscriberData;
        this.lastRequestDate = new Date(System.currentTimeMillis());
    }

    public Subscriber(Rloc srcRloc, Eid srcEid, int subscriberTtl) {
        this(srcRloc, srcEid, subscriberTtl, new Date(System.currentTimeMillis()));
    }

    public Subscriber(Rloc srcRloc, Eid srcEid, int subscriberTtl, Date lastRequestDate) {
        this.data = new SubscriberDataBuilder().setRloc(srcRloc).setEid(srcEid).setTtl(Integer.valueOf(subscriberTtl)).build();
        this.lastRequestDate = lastRequestDate;
    }

    public SubscriberData getSubscriberData() {
        return this.data;
    }

    public Rloc getSrcRloc() {
        return this.data.getRloc();
    }

    public Eid getSrcEid() {
        return this.data.getEid();
    }

    public Date getLastRequestDate() {
        return this.lastRequestDate;
    }

    public void setLastRequestDate(Date lastRequestDate) {
        this.lastRequestDate = lastRequestDate;
    }

    public int getSubscriberTtl() {
        return this.data.getTtl();
    }

    public void setSubscriberTtlByRecordTtl(Integer recordTtl) {
        SubscriberDataBuilder sdb = new SubscriberDataBuilder(this.data);
        sdb.setTtl(Integer.valueOf(Subscriber.recordTtlToSubscriberTime(recordTtl)));
        this.data = sdb.build();
    }

    public static int recordTtlToSubscriberTime(Integer recordTtl) {
        if (recordTtl != null) {
            return recordTtl + 10;
        }
        return DEFAULT_SUBSCRIBER_TIMEOUT;
    }

    public boolean timedOut() {
        return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.lastRequestDate.getTime()) > (long)this.data.getTtl().intValue();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Subscriber other = (Subscriber)obj;
        return this.data.equals(other.data);
    }

    public String toString() {
        return "_rloc=" + this.data.getRloc().toString() + ", _eid=" + this.data.getEid().toString() + ", _ttl=" + this.data.getTtl().toString() + ", last request @ " + this.lastRequestDate.toString();
    }
}

