/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ControlMessageBuilder
implements Builder<ControlMessage> {
    private MessageType _msgType;
    private Long _rxCount;
    private Long _txCount;
    Map<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> augmentation = Collections.emptyMap();

    public ControlMessageBuilder() {
    }

    public ControlMessageBuilder(ControlMessage base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._rxCount = base.getRxCount();
        this._txCount = base.getTxCount();
        if (base instanceof ControlMessageImpl) {
            ControlMessageImpl impl = (ControlMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>>(casted.augmentations());
        }
    }

    public MessageType getMsgType() {
        return this._msgType;
    }

    public Long getRxCount() {
        return this._rxCount;
    }

    public Long getTxCount() {
        return this._txCount;
    }

    public <E extends Augmentation<ControlMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ControlMessageBuilder setMsgType(MessageType value) {
        this._msgType = value;
        return this;
    }

    public ControlMessageBuilder setRxCount(Long value) {
        this._rxCount = value;
        return this;
    }

    public ControlMessageBuilder setTxCount(Long value) {
        this._txCount = value;
        return this;
    }

    public ControlMessageBuilder addAugmentation(Class<? extends Augmentation<ControlMessage>> augmentationType, Augmentation<ControlMessage> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ControlMessageBuilder removeAugmentation(Class<? extends Augmentation<ControlMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ControlMessage build() {
        return new ControlMessageImpl(this);
    }

    private static final class ControlMessageImpl
    implements ControlMessage {
        private final MessageType _msgType;
        private final Long _rxCount;
        private final Long _txCount;
        private Map<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ControlMessage> getImplementedInterface() {
            return ControlMessage.class;
        }

        private ControlMessageImpl(ControlMessageBuilder base) {
            this._msgType = base.getMsgType();
            this._rxCount = base.getRxCount();
            this._txCount = base.getTxCount();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public MessageType getMsgType() {
            return this._msgType;
        }

        @Override
        public Long getRxCount() {
            return this._rxCount;
        }

        @Override
        public Long getTxCount() {
            return this._txCount;
        }

        public <E extends Augmentation<ControlMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._msgType);
            result = 31 * result + Objects.hashCode(this._rxCount);
            result = 31 * result + Objects.hashCode(this._txCount);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ControlMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ControlMessage other = (ControlMessage)obj;
            if (!Objects.equals(this._msgType, other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._rxCount, other.getRxCount())) {
                return false;
            }
            if (!Objects.equals(this._txCount, other.getTxCount())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ControlMessageImpl otherImpl = (ControlMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ControlMessage>>, Augmentation<ControlMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ControlMessage [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append(this._msgType);
                builder.append(", ");
            }
            if (this._rxCount != null) {
                builder.append("_rxCount=");
                builder.append(this._rxCount);
                builder.append(", ");
            }
            if (this._txCount != null) {
                builder.append("_txCount=");
                builder.append(this._txCount);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

