/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChange;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.DstSubscriberItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.SubscriberItem;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingChangedBuilder
implements Builder<MappingChanged> {
    private MappingChange _changeType;
    private List<DstSubscriberItem> _dstSubscriberItem;
    private MappingRecord _mappingRecord;
    private List<SubscriberItem> _subscriberItem;
    Map<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> augmentation = Collections.emptyMap();

    public MappingChangedBuilder() {
    }

    public MappingChangedBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingChangedBuilder(MappingChanged base) {
        AugmentationHolder casted;
        this._changeType = base.getChangeType();
        this._dstSubscriberItem = base.getDstSubscriberItem();
        this._mappingRecord = base.getMappingRecord();
        this._subscriberItem = base.getSubscriberItem();
        if (base instanceof MappingChangedImpl) {
            MappingChangedImpl impl = (MappingChangedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordContainer) {
            this._mappingRecord = ((MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer] \nbut was: " + arg);
        }
    }

    public MappingChange getChangeType() {
        return this._changeType;
    }

    public List<DstSubscriberItem> getDstSubscriberItem() {
        return this._dstSubscriberItem;
    }

    public MappingRecord getMappingRecord() {
        return this._mappingRecord;
    }

    public List<SubscriberItem> getSubscriberItem() {
        return this._subscriberItem;
    }

    public <E extends Augmentation<MappingChanged>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MappingChangedBuilder setChangeType(MappingChange value) {
        this._changeType = value;
        return this;
    }

    public MappingChangedBuilder setDstSubscriberItem(List<DstSubscriberItem> value) {
        this._dstSubscriberItem = value;
        return this;
    }

    public MappingChangedBuilder setMappingRecord(MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }

    public MappingChangedBuilder setSubscriberItem(List<SubscriberItem> value) {
        this._subscriberItem = value;
        return this;
    }

    public MappingChangedBuilder addAugmentation(Class<? extends Augmentation<MappingChanged>> augmentationType, Augmentation<MappingChanged> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MappingChangedBuilder removeAugmentation(Class<? extends Augmentation<MappingChanged>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MappingChanged build() {
        return new MappingChangedImpl(this);
    }

    private static final class MappingChangedImpl
    implements MappingChanged {
        private final MappingChange _changeType;
        private final List<DstSubscriberItem> _dstSubscriberItem;
        private final MappingRecord _mappingRecord;
        private final List<SubscriberItem> _subscriberItem;
        private Map<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MappingChanged> getImplementedInterface() {
            return MappingChanged.class;
        }

        private MappingChangedImpl(MappingChangedBuilder base) {
            this._changeType = base.getChangeType();
            this._dstSubscriberItem = base.getDstSubscriberItem();
            this._mappingRecord = base.getMappingRecord();
            this._subscriberItem = base.getSubscriberItem();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>>(base.augmentation);
                }
            }
        }

        @Override
        public MappingChange getChangeType() {
            return this._changeType;
        }

        @Override
        public List<DstSubscriberItem> getDstSubscriberItem() {
            return this._dstSubscriberItem;
        }

        public MappingRecord getMappingRecord() {
            return this._mappingRecord;
        }

        @Override
        public List<SubscriberItem> getSubscriberItem() {
            return this._subscriberItem;
        }

        public <E extends Augmentation<MappingChanged>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._changeType);
            result = 31 * result + Objects.hashCode(this._dstSubscriberItem);
            result = 31 * result + Objects.hashCode(this._mappingRecord);
            result = 31 * result + Objects.hashCode(this._subscriberItem);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MappingChanged.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MappingChanged other = (MappingChanged)obj;
            if (!Objects.equals((Object)this._changeType, (Object)other.getChangeType())) {
                return false;
            }
            if (!Objects.equals(this._dstSubscriberItem, other.getDstSubscriberItem())) {
                return false;
            }
            if (!Objects.equals(this._mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals(this._subscriberItem, other.getSubscriberItem())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MappingChangedImpl otherImpl = (MappingChangedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MappingChanged>>, Augmentation<MappingChanged>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "MappingChanged [";
            StringBuilder builder = new StringBuilder(name);
            if (this._changeType != null) {
                builder.append("_changeType=");
                builder.append((Object)this._changeType);
                builder.append(", ");
            }
            if (this._dstSubscriberItem != null) {
                builder.append("_dstSubscriberItem=");
                builder.append(this._dstSubscriberItem);
                builder.append(", ");
            }
            if (this._mappingRecord != null) {
                builder.append("_mappingRecord=");
                builder.append(this._mappingRecord);
                builder.append(", ");
            }
            if (this._subscriberItem != null) {
                builder.append("_subscriberItem=");
                builder.append(this._subscriberItem);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

