/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.LastUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingDatabaseBuilder
implements Builder<MappingDatabase> {
    private LastUpdated _lastUpdated;
    private List<VirtualNetworkIdentifier> _virtualNetworkIdentifier;
    Map<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> augmentation = Collections.emptyMap();

    public MappingDatabaseBuilder() {
    }

    public MappingDatabaseBuilder(MappingDatabase base) {
        AugmentationHolder casted;
        this._lastUpdated = base.getLastUpdated();
        this._virtualNetworkIdentifier = base.getVirtualNetworkIdentifier();
        if (base instanceof MappingDatabaseImpl) {
            MappingDatabaseImpl impl = (MappingDatabaseImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>(casted.augmentations());
        }
    }

    public LastUpdated getLastUpdated() {
        return this._lastUpdated;
    }

    public List<VirtualNetworkIdentifier> getVirtualNetworkIdentifier() {
        return this._virtualNetworkIdentifier;
    }

    public <E extends Augmentation<MappingDatabase>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MappingDatabaseBuilder setLastUpdated(LastUpdated value) {
        this._lastUpdated = value;
        return this;
    }

    public MappingDatabaseBuilder setVirtualNetworkIdentifier(List<VirtualNetworkIdentifier> value) {
        this._virtualNetworkIdentifier = value;
        return this;
    }

    public MappingDatabaseBuilder addAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType, Augmentation<MappingDatabase> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MappingDatabaseBuilder removeAugmentation(Class<? extends Augmentation<MappingDatabase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MappingDatabase build() {
        return new MappingDatabaseImpl(this);
    }

    private static final class MappingDatabaseImpl
    implements MappingDatabase {
        private final LastUpdated _lastUpdated;
        private final List<VirtualNetworkIdentifier> _virtualNetworkIdentifier;
        private Map<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MappingDatabase> getImplementedInterface() {
            return MappingDatabase.class;
        }

        private MappingDatabaseImpl(MappingDatabaseBuilder base) {
            this._lastUpdated = base.getLastUpdated();
            this._virtualNetworkIdentifier = base.getVirtualNetworkIdentifier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>>(base.augmentation);
                }
            }
        }

        @Override
        public LastUpdated getLastUpdated() {
            return this._lastUpdated;
        }

        @Override
        public List<VirtualNetworkIdentifier> getVirtualNetworkIdentifier() {
            return this._virtualNetworkIdentifier;
        }

        public <E extends Augmentation<MappingDatabase>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lastUpdated);
            result = 31 * result + Objects.hashCode(this._virtualNetworkIdentifier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MappingDatabase.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MappingDatabase other = (MappingDatabase)obj;
            if (!Objects.equals(this._lastUpdated, other.getLastUpdated())) {
                return false;
            }
            if (!Objects.equals(this._virtualNetworkIdentifier, other.getVirtualNetworkIdentifier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MappingDatabaseImpl otherImpl = (MappingDatabaseImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MappingDatabase>>, Augmentation<MappingDatabase>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "MappingDatabase [";
            StringBuilder builder = new StringBuilder(name);
            if (this._lastUpdated != null) {
                builder.append("_lastUpdated=");
                builder.append(this._lastUpdated);
                builder.append(", ");
            }
            if (this._virtualNetworkIdentifier != null) {
                builder.append("_virtualNetworkIdentifier=");
                builder.append(this._virtualNetworkIdentifier);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

