/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKeyKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AuthenticationKeyBuilder
implements Builder<AuthenticationKey> {
    private Eid _eid;
    private EidUri _eidUri;
    private AuthenticationKeyKey _key;
    private MappingAuthkey _mappingAuthkey;
    Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> augmentation = Collections.emptyMap();

    public AuthenticationKeyBuilder() {
    }

    public AuthenticationKeyBuilder(EidContainer arg) {
        this._eid = arg.getEid();
    }

    public AuthenticationKeyBuilder(MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }

    public AuthenticationKeyBuilder(AuthenticationKey base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AuthenticationKeyKey(base.getEidUri());
            this._eidUri = base.getEidUri();
        } else {
            this._key = base.getKey();
            this._eidUri = this._key.getEidUri();
        }
        this._eid = base.getEid();
        this._mappingAuthkey = base.getMappingAuthkey();
        if (base instanceof AuthenticationKeyImpl) {
            AuthenticationKeyImpl impl = (AuthenticationKeyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingAuthkeyContainer) {
            this._mappingAuthkey = ((MappingAuthkeyContainer)arg).getMappingAuthkey();
            isValidArg = true;
        }
        if (arg instanceof EidContainer) {
            this._eid = ((EidContainer)arg).getEid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer] \nbut was: " + arg);
        }
    }

    public Eid getEid() {
        return this._eid;
    }

    public EidUri getEidUri() {
        return this._eidUri;
    }

    public AuthenticationKeyKey getKey() {
        return this._key;
    }

    public MappingAuthkey getMappingAuthkey() {
        return this._mappingAuthkey;
    }

    public <E extends Augmentation<AuthenticationKey>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AuthenticationKeyBuilder setEid(Eid value) {
        this._eid = value;
        return this;
    }

    public AuthenticationKeyBuilder setEidUri(EidUri value) {
        this._eidUri = value;
        return this;
    }

    public AuthenticationKeyBuilder setKey(AuthenticationKeyKey value) {
        this._key = value;
        return this;
    }

    public AuthenticationKeyBuilder setMappingAuthkey(MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }

    public AuthenticationKeyBuilder addAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType, Augmentation<AuthenticationKey> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public AuthenticationKeyBuilder removeAugmentation(Class<? extends Augmentation<AuthenticationKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AuthenticationKey build() {
        return new AuthenticationKeyImpl(this);
    }

    private static final class AuthenticationKeyImpl
    implements AuthenticationKey {
        private final Eid _eid;
        private final EidUri _eidUri;
        private final AuthenticationKeyKey _key;
        private final MappingAuthkey _mappingAuthkey;
        private Map<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AuthenticationKey> getImplementedInterface() {
            return AuthenticationKey.class;
        }

        private AuthenticationKeyImpl(AuthenticationKeyBuilder base) {
            if (base.getKey() == null) {
                this._key = new AuthenticationKeyKey(base.getEidUri());
                this._eidUri = base.getEidUri();
            } else {
                this._key = base.getKey();
                this._eidUri = this._key.getEidUri();
            }
            this._eid = base.getEid();
            this._mappingAuthkey = base.getMappingAuthkey();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>>(base.augmentation);
                }
            }
        }

        public Eid getEid() {
            return this._eid;
        }

        @Override
        public EidUri getEidUri() {
            return this._eidUri;
        }

        @Override
        public AuthenticationKeyKey getKey() {
            return this._key;
        }

        public MappingAuthkey getMappingAuthkey() {
            return this._mappingAuthkey;
        }

        public <E extends Augmentation<AuthenticationKey>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._eid);
            result = 31 * result + Objects.hashCode(this._eidUri);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._mappingAuthkey);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AuthenticationKey.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AuthenticationKey other = (AuthenticationKey)obj;
            if (!Objects.equals(this._eid, other.getEid())) {
                return false;
            }
            if (!Objects.equals(this._eidUri, other.getEidUri())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._mappingAuthkey, other.getMappingAuthkey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AuthenticationKeyImpl otherImpl = (AuthenticationKeyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AuthenticationKey>>, Augmentation<AuthenticationKey>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "AuthenticationKey [";
            StringBuilder builder = new StringBuilder(name);
            if (this._eid != null) {
                builder.append("_eid=");
                builder.append(this._eid);
                builder.append(", ");
            }
            if (this._eidUri != null) {
                builder.append("_eidUri=");
                builder.append(this._eidUri);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._mappingAuthkey != null) {
                builder.append("_mappingAuthkey=");
                builder.append(this._mappingAuthkey);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

