/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SiteId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.MappingKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MappingBuilder
implements Builder<Mapping> {
    private EidUri _eidUri;
    private MappingKey _key;
    private MappingRecord _mappingRecord;
    private MappingOrigin _origin;
    private List<SiteId> _siteId;
    private List<XtrIdMapping> _xtrIdMapping;
    Map<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> augmentation = Collections.emptyMap();

    public MappingBuilder() {
    }

    public MappingBuilder(MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingBuilder(Mapping base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new MappingKey(base.getEidUri(), base.getOrigin());
            this._eidUri = base.getEidUri();
            this._origin = base.getOrigin();
        } else {
            this._key = base.getKey();
            this._eidUri = this._key.getEidUri();
            this._origin = this._key.getOrigin();
        }
        this._mappingRecord = base.getMappingRecord();
        this._siteId = base.getSiteId();
        this._xtrIdMapping = base.getXtrIdMapping();
        if (base instanceof MappingImpl) {
            MappingImpl impl = (MappingImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MappingRecordContainer) {
            this._mappingRecord = ((MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer] \nbut was: " + arg);
        }
    }

    public EidUri getEidUri() {
        return this._eidUri;
    }

    public MappingKey getKey() {
        return this._key;
    }

    public MappingRecord getMappingRecord() {
        return this._mappingRecord;
    }

    public MappingOrigin getOrigin() {
        return this._origin;
    }

    public List<SiteId> getSiteId() {
        return this._siteId;
    }

    public List<XtrIdMapping> getXtrIdMapping() {
        return this._xtrIdMapping;
    }

    public <E extends Augmentation<Mapping>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MappingBuilder setEidUri(EidUri value) {
        this._eidUri = value;
        return this;
    }

    public MappingBuilder setKey(MappingKey value) {
        this._key = value;
        return this;
    }

    public MappingBuilder setMappingRecord(MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }

    public MappingBuilder setOrigin(MappingOrigin value) {
        this._origin = value;
        return this;
    }

    public MappingBuilder setSiteId(List<SiteId> value) {
        this._siteId = value;
        return this;
    }

    public MappingBuilder setXtrIdMapping(List<XtrIdMapping> value) {
        this._xtrIdMapping = value;
        return this;
    }

    public MappingBuilder addAugmentation(Class<? extends Augmentation<Mapping>> augmentationType, Augmentation<Mapping> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MappingBuilder removeAugmentation(Class<? extends Augmentation<Mapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Mapping build() {
        return new MappingImpl(this);
    }

    private static final class MappingImpl
    implements Mapping {
        private final EidUri _eidUri;
        private final MappingKey _key;
        private final MappingRecord _mappingRecord;
        private final MappingOrigin _origin;
        private final List<SiteId> _siteId;
        private final List<XtrIdMapping> _xtrIdMapping;
        private Map<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Mapping> getImplementedInterface() {
            return Mapping.class;
        }

        private MappingImpl(MappingBuilder base) {
            if (base.getKey() == null) {
                this._key = new MappingKey(base.getEidUri(), base.getOrigin());
                this._eidUri = base.getEidUri();
                this._origin = base.getOrigin();
            } else {
                this._key = base.getKey();
                this._eidUri = this._key.getEidUri();
                this._origin = this._key.getOrigin();
            }
            this._mappingRecord = base.getMappingRecord();
            this._siteId = base.getSiteId();
            this._xtrIdMapping = base.getXtrIdMapping();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>>(base.augmentation);
                }
            }
        }

        @Override
        public EidUri getEidUri() {
            return this._eidUri;
        }

        @Override
        public MappingKey getKey() {
            return this._key;
        }

        public MappingRecord getMappingRecord() {
            return this._mappingRecord;
        }

        @Override
        public MappingOrigin getOrigin() {
            return this._origin;
        }

        @Override
        public List<SiteId> getSiteId() {
            return this._siteId;
        }

        @Override
        public List<XtrIdMapping> getXtrIdMapping() {
            return this._xtrIdMapping;
        }

        public <E extends Augmentation<Mapping>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._eidUri);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._mappingRecord);
            result = 31 * result + Objects.hashCode((Object)this._origin);
            result = 31 * result + Objects.hashCode(this._siteId);
            result = 31 * result + Objects.hashCode(this._xtrIdMapping);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mapping.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Mapping other = (Mapping)obj;
            if (!Objects.equals(this._eidUri, other.getEidUri())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals((Object)this._origin, (Object)other.getOrigin())) {
                return false;
            }
            if (!Objects.equals(this._siteId, other.getSiteId())) {
                return false;
            }
            if (!Objects.equals(this._xtrIdMapping, other.getXtrIdMapping())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MappingImpl otherImpl = (MappingImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Mapping>>, Augmentation<Mapping>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Mapping [";
            StringBuilder builder = new StringBuilder(name);
            if (this._eidUri != null) {
                builder.append("_eidUri=");
                builder.append(this._eidUri);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._mappingRecord != null) {
                builder.append("_mappingRecord=");
                builder.append(this._mappingRecord);
                builder.append(", ");
            }
            if (this._origin != null) {
                builder.append("_origin=");
                builder.append((Object)this._origin);
                builder.append(", ");
            }
            if (this._siteId != null) {
                builder.append("_siteId=");
                builder.append(this._siteId);
                builder.append(", ");
            }
            if (this._xtrIdMapping != null) {
                builder.append("_xtrIdMapping=");
                builder.append(this._xtrIdMapping);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

