/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.VniUri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.database.VirtualNetworkIdentifierKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VirtualNetworkIdentifierBuilder
implements Builder<VirtualNetworkIdentifier> {
    private List<AuthenticationKey> _authenticationKey;
    private VirtualNetworkIdentifierKey _key;
    private List<Mapping> _mapping;
    private VniUri _vni;
    Map<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> augmentation = Collections.emptyMap();

    public VirtualNetworkIdentifierBuilder() {
    }

    public VirtualNetworkIdentifierBuilder(DbInstance arg) {
        this._vni = arg.getVni();
        this._mapping = arg.getMapping();
        this._authenticationKey = arg.getAuthenticationKey();
    }

    public VirtualNetworkIdentifierBuilder(VirtualNetworkIdentifier base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new VirtualNetworkIdentifierKey(base.getVni());
            this._vni = base.getVni();
        } else {
            this._key = base.getKey();
            this._vni = this._key.getVni();
        }
        this._authenticationKey = base.getAuthenticationKey();
        this._mapping = base.getMapping();
        if (base instanceof VirtualNetworkIdentifierImpl) {
            VirtualNetworkIdentifierImpl impl = (VirtualNetworkIdentifierImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DbInstance) {
            this._vni = ((DbInstance)arg).getVni();
            this._mapping = ((DbInstance)arg).getMapping();
            this._authenticationKey = ((DbInstance)arg).getAuthenticationKey();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.DbInstance] \nbut was: " + arg);
        }
    }

    public List<AuthenticationKey> getAuthenticationKey() {
        return this._authenticationKey;
    }

    public VirtualNetworkIdentifierKey getKey() {
        return this._key;
    }

    public List<Mapping> getMapping() {
        return this._mapping;
    }

    public VniUri getVni() {
        return this._vni;
    }

    public <E extends Augmentation<VirtualNetworkIdentifier>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VirtualNetworkIdentifierBuilder setAuthenticationKey(List<AuthenticationKey> value) {
        this._authenticationKey = value;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setKey(VirtualNetworkIdentifierKey value) {
        this._key = value;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setMapping(List<Mapping> value) {
        this._mapping = value;
        return this;
    }

    public VirtualNetworkIdentifierBuilder setVni(VniUri value) {
        this._vni = value;
        return this;
    }

    public VirtualNetworkIdentifierBuilder addAugmentation(Class<? extends Augmentation<VirtualNetworkIdentifier>> augmentationType, Augmentation<VirtualNetworkIdentifier> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VirtualNetworkIdentifierBuilder removeAugmentation(Class<? extends Augmentation<VirtualNetworkIdentifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VirtualNetworkIdentifier build() {
        return new VirtualNetworkIdentifierImpl(this);
    }

    private static final class VirtualNetworkIdentifierImpl
    implements VirtualNetworkIdentifier {
        private final List<AuthenticationKey> _authenticationKey;
        private final VirtualNetworkIdentifierKey _key;
        private final List<Mapping> _mapping;
        private final VniUri _vni;
        private Map<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<VirtualNetworkIdentifier> getImplementedInterface() {
            return VirtualNetworkIdentifier.class;
        }

        private VirtualNetworkIdentifierImpl(VirtualNetworkIdentifierBuilder base) {
            if (base.getKey() == null) {
                this._key = new VirtualNetworkIdentifierKey(base.getVni());
                this._vni = base.getVni();
            } else {
                this._key = base.getKey();
                this._vni = this._key.getVni();
            }
            this._authenticationKey = base.getAuthenticationKey();
            this._mapping = base.getMapping();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>>(base.augmentation);
                }
            }
        }

        @Override
        public List<AuthenticationKey> getAuthenticationKey() {
            return this._authenticationKey;
        }

        @Override
        public VirtualNetworkIdentifierKey getKey() {
            return this._key;
        }

        @Override
        public List<Mapping> getMapping() {
            return this._mapping;
        }

        @Override
        public VniUri getVni() {
            return this._vni;
        }

        public <E extends Augmentation<VirtualNetworkIdentifier>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._authenticationKey);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._mapping);
            result = 31 * result + Objects.hashCode(this._vni);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VirtualNetworkIdentifier.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VirtualNetworkIdentifier other = (VirtualNetworkIdentifier)obj;
            if (!Objects.equals(this._authenticationKey, other.getAuthenticationKey())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._mapping, other.getMapping())) {
                return false;
            }
            if (!Objects.equals(this._vni, other.getVni())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VirtualNetworkIdentifierImpl otherImpl = (VirtualNetworkIdentifierImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VirtualNetworkIdentifier>>, Augmentation<VirtualNetworkIdentifier>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "VirtualNetworkIdentifier [";
            StringBuilder builder = new StringBuilder(name);
            if (this._authenticationKey != null) {
                builder.append("_authenticationKey=");
                builder.append(this._authenticationKey);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._mapping != null) {
                builder.append("_mapping=");
                builder.append(this._mapping);
                builder.append(", ");
            }
            if (this._vni != null) {
                builder.append("_vni=");
                builder.append(this._vni);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

