package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * grouping cache-stats {
 *     leaf hits {
 *         type int64;
 *     }
 *     leaf misses {
 *         type int64;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/cache-stats</i>
 *
 */
public interface CacheStats
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:lisp-sb",
        "2015-09-04", "cache-stats").intern();

    /**
     * @return <code>java.lang.Long</code> <code>hits</code>, or <code>null</code> if not present
     */
    java.lang.Long getHits();
    
    /**
     * @return <code>java.lang.Long</code> <code>misses</code>, or <code>null</code> if not present
     */
    java.lang.Long getMisses();

}

