package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * grouping ctrl-msg-stats {
 *     leaf rx-unknown {
 *         type int64;
 *     }
 *     leaf tx-errors {
 *         type int64;
 *     }
 *     list control-message {
 *         leaf msg-type {
 *             type message-type;
 *         }
 *         leaf rx-count {
 *             type int64;
 *         }
 *         leaf tx-count {
 *             type int64;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/ctrl-msg-stats</i>
 *
 */
public interface CtrlMsgStats
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:lisp-sb",
        "2015-09-04", "ctrl-msg-stats").intern();

    /**
     * @return <code>java.lang.Long</code> <code>rxUnknown</code>, or <code>null</code> if not present
     */
    java.lang.Long getRxUnknown();
    
    /**
     * @return <code>java.lang.Long</code> <code>txErrors</code>, or <code>null</code> if not present
     */
    java.lang.Long getTxErrors();
    
    /**
     * @return <code>java.util.List</code> <code>controlMessage</code>, or <code>null</code> if not present
     */
    List<ControlMessage> getControlMessage();

}

