package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.MapRegisterCacheStats;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * container output {
 *     container control-message-stats {
 *         leaf rx-unknown {
 *             type int64;
 *         }
 *         leaf tx-errors {
 *             type int64;
 *         }
 *         list control-message {
 *             leaf msg-type {
 *                 type message-type;
 *             }
 *             leaf rx-count {
 *                 type int64;
 *             }
 *             leaf tx-count {
 *                 type int64;
 *             }
 *         }
 *         uses ctrl-msg-stats;
 *     }
 *     container map-register-cache-stats {
 *         leaf hits {
 *             type int64;
 *         }
 *         leaf misses {
 *             type int64;
 *         }
 *         uses cache-stats;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/get-stats/output</i>
 *
 * <p>To create instances of this class use {@link GetStatsOutputBuilder}.
 * @see GetStatsOutputBuilder
 *
 */
public interface GetStatsOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.GetStatsOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:lisp-sb",
        "2015-09-04", "output").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats</code> <code>controlMessageStats</code>, or <code>null</code> if not present
     */
    ControlMessageStats getControlMessageStats();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.MapRegisterCacheStats</code> <code>mapRegisterCacheStats</code>, or <code>null</code> if not present
     */
    MapRegisterCacheStats getMapRegisterCacheStats();

}

