package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * list control-message {
 *     leaf msg-type {
 *         type message-type;
 *     }
 *     leaf rx-count {
 *         type int64;
 *     }
 *     leaf tx-count {
 *         type int64;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/ctrl-msg-stats/control-message</i>
 *
 * <p>To create instances of this class use {@link ControlMessageBuilder}.
 * @see ControlMessageBuilder
 *
 *
 */
public interface ControlMessage
    extends
    ChildOf<CtrlMsgStats>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:lisp-sb",
        "2015-09-04", "control-message").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MessageType</code> <code>msgType</code>, or <code>null</code> if not present
     */
    MessageType getMsgType();
    
    /**
     * @return <code>java.lang.Long</code> <code>rxCount</code>, or <code>null</code> if not present
     */
    java.lang.Long getRxCount();
    
    /**
     * @return <code>java.lang.Long</code> <code>txCount</code>, or <code>null</code> if not present
     */
    java.lang.Long getTxCount();

}

