package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.GetStatsOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-lisp-sb</b>
 * <pre>
 * container control-message-stats {
 *     leaf rx-unknown {
 *         type int64;
 *     }
 *     leaf tx-errors {
 *         type int64;
 *     }
 *     list control-message {
 *         leaf msg-type {
 *             type message-type;
 *         }
 *         leaf rx-count {
 *             type int64;
 *         }
 *         leaf tx-count {
 *             type int64;
 *         }
 *     }
 *     uses ctrl-msg-stats;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-lisp-sb/get-stats/output/control-message-stats</i>
 *
 * <p>To create instances of this class use {@link ControlMessageStatsBuilder}.
 * @see ControlMessageStatsBuilder
 *
 */
public interface ControlMessageStats
    extends
    ChildOf<GetStatsOutput>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>,
    CtrlMsgStats
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:lisp-sb",
        "2015-09-04", "control-message-stats").intern();


}

