package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.List;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.ctrl.msg.stats.ControlMessage;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats
 *
 */
public class ControlMessageStatsBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats> {

    private List<ControlMessage> _controlMessage;
    private java.lang.Long _rxUnknown;
    private java.lang.Long _txErrors;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>> augmentation = Collections.emptyMap();

    public ControlMessageStatsBuilder() {
    }
    public ControlMessageStatsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats arg) {
        this._rxUnknown = arg.getRxUnknown();
        this._txErrors = arg.getTxErrors();
        this._controlMessage = arg.getControlMessage();
    }

    public ControlMessageStatsBuilder(ControlMessageStats base) {
        this._controlMessage = base.getControlMessage();
        this._rxUnknown = base.getRxUnknown();
        this._txErrors = base.getTxErrors();
        if (base instanceof ControlMessageStatsImpl) {
            ControlMessageStatsImpl impl = (ControlMessageStatsImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats) {
            this._rxUnknown = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats)arg).getRxUnknown();
            this._txErrors = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats)arg).getTxErrors();
            this._controlMessage = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats)arg).getControlMessage();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.CtrlMsgStats] \n" +
              "but was: " + arg
            );
        }
    }

    public List<ControlMessage> getControlMessage() {
        return _controlMessage;
    }
    
    public java.lang.Long getRxUnknown() {
        return _rxUnknown;
    }
    
    public java.lang.Long getTxErrors() {
        return _txErrors;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ControlMessageStatsBuilder setControlMessage(final List<ControlMessage> value) {
        this._controlMessage = value;
        return this;
    }
    
     
    public ControlMessageStatsBuilder setRxUnknown(final java.lang.Long value) {
        this._rxUnknown = value;
        return this;
    }
    
     
    public ControlMessageStatsBuilder setTxErrors(final java.lang.Long value) {
        this._txErrors = value;
        return this;
    }
    
    public ControlMessageStatsBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ControlMessageStatsBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ControlMessageStats build() {
        return new ControlMessageStatsImpl(this);
    }

    private static final class ControlMessageStatsImpl implements ControlMessageStats {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats.class;
        }

        private final List<ControlMessage> _controlMessage;
        private final java.lang.Long _rxUnknown;
        private final java.lang.Long _txErrors;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>> augmentation = Collections.emptyMap();

        private ControlMessageStatsImpl(ControlMessageStatsBuilder base) {
            this._controlMessage = base.getControlMessage();
            this._rxUnknown = base.getRxUnknown();
            this._txErrors = base.getTxErrors();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public List<ControlMessage> getControlMessage() {
            return _controlMessage;
        }
        
        @Override
        public java.lang.Long getRxUnknown() {
            return _rxUnknown;
        }
        
        @Override
        public java.lang.Long getTxErrors() {
            return _txErrors;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_controlMessage);
            result = prime * result + Objects.hashCode(_rxUnknown);
            result = prime * result + Objects.hashCode(_txErrors);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats other = (org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats)obj;
            if (!Objects.equals(_controlMessage, other.getControlMessage())) {
                return false;
            }
            if (!Objects.equals(_rxUnknown, other.getRxUnknown())) {
                return false;
            }
            if (!Objects.equals(_txErrors, other.getTxErrors())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ControlMessageStatsImpl otherImpl = (ControlMessageStatsImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.sb.rev150904.get.stats.output.ControlMessageStats>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "ControlMessageStats [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_controlMessage != null) {
                builder.append("_controlMessage=");
                builder.append(_controlMessage);
                builder.append(", ");
            }
            if (_rxUnknown != null) {
                builder.append("_rxUnknown=");
                builder.append(_rxUnknown);
                builder.append(", ");
            }
            if (_txErrors != null) {
                builder.append("_txErrors=");
                builder.append(_txErrors);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
