package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;

/**
 * A classifier for endpoint-id elements which allows direct access to a 
 * element in the data tree.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * identity eid-context {
 *     description
 *         "A classifier for endpoint-id elements which allows direct access to a particular element in the data tree.";
 *     status CURRENT;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/eid-context</i>
 *
 */
public abstract class EidContext extends BaseIdentity
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:mappingservice",
        "2015-09-06", "eid-context").intern();


    public EidContext() {
    
    
    }
    






}

