package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordList;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * container output {
 *     list mapping-record-item {
 *         key "mapping-record-item-id";
 *         leaf mapping-record-item-id {
 *             type string;
 *         }
 *         container mapping-record {
 *             leaf recordTtl {
 *                 type int32;
 *             }
 *             leaf mapVersion {
 *                 type int16;
 *             }
 *             leaf action {
 *                 type enumeration;
 *             }
 *             leaf authoritative {
 *                 type boolean;
 *             }
 *             leaf xtr-id {
 *                 type xtr-id;
 *             }
 *             leaf site-id {
 *                 type site-id;
 *             }
 *             leaf source-rloc {
 *                 type ip-address-binary;
 *             }
 *             leaf timestamp {
 *                 type int64;
 *             }
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *             list LocatorRecord {
 *                 key "locator-id";
 *                 leaf locator-id {
 *                     type string;
 *                 }
 *                 leaf priority {
 *                     type uint8;
 *                 }
 *                 leaf weight {
 *                     type uint8;
 *                 }
 *                 leaf multicastPriority {
 *                     type uint8;
 *                 }
 *                 leaf multicastWeight {
 *                     type uint8;
 *                 }
 *                 leaf localLocator {
 *                     type boolean;
 *                 }
 *                 leaf rlocProbed {
 *                     type boolean;
 *                 }
 *                 leaf routed {
 *                     type boolean;
 *                 }
 *                 container rloc {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses rloc-container;
 *             }
 *             uses eid-container;
 *             uses mapping-record-metadata;
 *             uses LocatorRecords;
 *         }
 *         uses mapping-record-container;
 *     }
 *     uses mapping-record-list;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/get-mappings/output</i>
 *
 * <p>To create instances of this class use {@link GetMappingsOutputBuilder}.
 * @see GetMappingsOutputBuilder
 *
 */
public interface GetMappingsOutput
    extends
    MappingRecordList,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.GetMappingsOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:mappingservice",
        "2015-09-06", "output").intern();


}

