package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem;
import java.util.List;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * grouping mapping-authkey-list {
 *     list mapping-authkey-item {
 *         key "mapping-authkey-item-id";
 *         leaf mapping-authkey-item-id {
 *             type string;
 *         }
 *         container mapping-authkey {
 *             leaf key-string {
 *                 type string;
 *             }
 *             leaf key-type {
 *                 type uint16;
 *             }
 *         }
 *         uses mapping-authkey-container;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/mapping-authkey-list</i>
 *
 */
public interface MappingAuthkeyList
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:mappingservice",
        "2015-09-06", "mapping-authkey-list").intern();

    /**
     * @return <code>java.util.List</code> <code>mappingAuthkeyItem</code>, or <code>null</code> if not present
     */
    List<MappingAuthkeyItem> getMappingAuthkeyItem();

}

