package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.SubscriberItem;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import java.util.Objects;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.changed.DstSubscriberItem;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged
 *
 */
public class MappingChangedBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged> {

    private MappingChange _changeType;
    private List<DstSubscriberItem> _dstSubscriberItem;
    private Eid _eid;
    private MappingRecord _mappingRecord;
    private List<SubscriberItem> _subscriberItem;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>> augmentation = Collections.emptyMap();

    public MappingChangedBuilder() {
    }
    public MappingChangedBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer arg) {
        this._eid = arg.getEid();
    }
    public MappingChangedBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingChangedBuilder(MappingChanged base) {
        this._changeType = base.getChangeType();
        this._dstSubscriberItem = base.getDstSubscriberItem();
        this._eid = base.getEid();
        this._mappingRecord = base.getMappingRecord();
        this._subscriberItem = base.getSubscriberItem();
        if (base instanceof MappingChangedImpl) {
            MappingChangedImpl impl = (MappingChangedImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer) {
            this._eid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer)arg).getEid();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer) {
            this._mappingRecord = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer] \n" +
              "but was: " + arg
            );
        }
    }

    public MappingChange getChangeType() {
        return _changeType;
    }
    
    public List<DstSubscriberItem> getDstSubscriberItem() {
        return _dstSubscriberItem;
    }
    
    public Eid getEid() {
        return _eid;
    }
    
    public MappingRecord getMappingRecord() {
        return _mappingRecord;
    }
    
    public List<SubscriberItem> getSubscriberItem() {
        return _subscriberItem;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public MappingChangedBuilder setChangeType(final MappingChange value) {
        this._changeType = value;
        return this;
    }
    
     
    public MappingChangedBuilder setDstSubscriberItem(final List<DstSubscriberItem> value) {
        this._dstSubscriberItem = value;
        return this;
    }
    
     
    public MappingChangedBuilder setEid(final Eid value) {
        this._eid = value;
        return this;
    }
    
     
    public MappingChangedBuilder setMappingRecord(final MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }
    
     
    public MappingChangedBuilder setSubscriberItem(final List<SubscriberItem> value) {
        this._subscriberItem = value;
        return this;
    }
    
    public MappingChangedBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MappingChangedBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MappingChanged build() {
        return new MappingChangedImpl(this);
    }

    private static final class MappingChangedImpl implements MappingChanged {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged.class;
        }

        private final MappingChange _changeType;
        private final List<DstSubscriberItem> _dstSubscriberItem;
        private final Eid _eid;
        private final MappingRecord _mappingRecord;
        private final List<SubscriberItem> _subscriberItem;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>> augmentation = Collections.emptyMap();

        private MappingChangedImpl(MappingChangedBuilder base) {
            this._changeType = base.getChangeType();
            this._dstSubscriberItem = base.getDstSubscriberItem();
            this._eid = base.getEid();
            this._mappingRecord = base.getMappingRecord();
            this._subscriberItem = base.getSubscriberItem();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public MappingChange getChangeType() {
            return _changeType;
        }
        
        @Override
        public List<DstSubscriberItem> getDstSubscriberItem() {
            return _dstSubscriberItem;
        }
        
        @Override
        public Eid getEid() {
            return _eid;
        }
        
        @Override
        public MappingRecord getMappingRecord() {
            return _mappingRecord;
        }
        
        @Override
        public List<SubscriberItem> getSubscriberItem() {
            return _subscriberItem;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_changeType);
            result = prime * result + Objects.hashCode(_dstSubscriberItem);
            result = prime * result + Objects.hashCode(_eid);
            result = prime * result + Objects.hashCode(_mappingRecord);
            result = prime * result + Objects.hashCode(_subscriberItem);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged other = (org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged)obj;
            if (!Objects.equals(_changeType, other.getChangeType())) {
                return false;
            }
            if (!Objects.equals(_dstSubscriberItem, other.getDstSubscriberItem())) {
                return false;
            }
            if (!Objects.equals(_eid, other.getEid())) {
                return false;
            }
            if (!Objects.equals(_mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals(_subscriberItem, other.getSubscriberItem())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MappingChangedImpl otherImpl = (MappingChangedImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingChanged>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "MappingChanged [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_changeType != null) {
                builder.append("_changeType=");
                builder.append(_changeType);
                builder.append(", ");
            }
            if (_dstSubscriberItem != null) {
                builder.append("_dstSubscriberItem=");
                builder.append(_dstSubscriberItem);
                builder.append(", ");
            }
            if (_eid != null) {
                builder.append("_eid=");
                builder.append(_eid);
                builder.append(", ");
            }
            if (_mappingRecord != null) {
                builder.append("_mappingRecord=");
                builder.append(_mappingRecord);
                builder.append(", ");
            }
            if (_subscriberItem != null) {
                builder.append("_subscriberItem=");
                builder.append(_subscriberItem);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
