package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * An MD-SAL based implementation of a LISP Map-Server database
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * module odl-mappingservice {
 *     yang-version 1;
 *     namespace "urn:opendaylight:lfm:mappingservice";
 *     prefix "mappingservice";
 *
 *     import ietf-inet-types { prefix "inet"; }
 *     
 *     import odl-lisp-proto { prefix "lisp-proto"; }
 *     
 *     import yang-ext { prefix "ext"; }
 *     revision 2015-09-06 {
 *         description "An MD-SAL based implementation of a LISP Map-Server database
 *         ";
 *     }
 *
 *     container mapping-database {
 *         list virtual-network-identifier {
 *             key "vni";
 *             leaf vni {
 *                 type vni-uri;
 *             }
 *             list mapping {
 *                 key "eid-uri" "origin";
 *                 leaf eid-uri {
 *                     type eid-uri;
 *                 }
 *                 leaf origin {
 *                     type mapping-origin;
 *                 }
 *                 leaf-list site-id {
 *                     type site-id;
 *                 }
 *                 list xtr-id-mapping {
 *                     key "xtr-id-uri";
 *                     leaf xtr-id-uri {
 *                         type xtr-id-uri;
 *                     }
 *                     container mapping-record {
 *                         leaf recordTtl {
 *                             type int32;
 *                         }
 *                         leaf mapVersion {
 *                             type int16;
 *                         }
 *                         leaf action {
 *                             type enumeration;
 *                         }
 *                         leaf authoritative {
 *                             type boolean;
 *                         }
 *                         leaf xtr-id {
 *                             type xtr-id;
 *                         }
 *                         leaf site-id {
 *                             type site-id;
 *                         }
 *                         leaf source-rloc {
 *                             type ip-address-binary;
 *                         }
 *                         leaf timestamp {
 *                             type int64;
 *                         }
 *                         container eid {
 *                             leaf address-type {
 *                                 type lisp-address-family-ref;
 *                             }
 *                             leaf virtual-network-id {
 *                                 type instance-id-type;
 *                             }
 *                             choice address {
 *                                 case afi-list {
 *                                     container afi-list {
 *                                         leaf-list address-list {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case application-data {
 *                                     container application-data {
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf protocol {
 *                                             type uint8;
 *                                         }
 *                                         leaf ip-tos {
 *                                             type int32;
 *                                         }
 *                                         leaf local-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf local-port-high {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-high {
 *                                             type port-number;
 *                                         }
 *                                     }
 *                                 }
 *                                 case as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                 }
 *                                 case as-number-lcaf {
 *                                     container as-number-lcaf {
 *                                         leaf as {
 *                                             type as-number;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case distinguished-name {
 *                                     leaf distinguished-name {
 *                                         type distinguished-name-type;
 *                                     }
 *                                 }
 *                                 case explicit-locator-path {
 *                                     container explicit-locator-path {
 *                                         list hop {
 *                                             key "hop-id";
 *                                             leaf hop-id {
 *                                                 type string;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf lrs-bits {
 *                                                 type bits;
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 case geo-coordinates {
 *                                     container geo-coordinates {
 *                                         leaf latitude {
 *                                             type bits;
 *                                         }
 *                                         leaf latitude-degrees {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude {
 *                                             type bits;
 *                                         }
 *                                         leaf longitude-degrees {
 *                                             type uint16;
 *                                         }
 *                                         leaf longitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf altitude {
 *                                             type int32;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case instance-id {
 *                                     container instance-id {
 *                                         leaf iid {
 *                                             type instance-id-type;
 *                                         }
 *                                         leaf mask-length {
 *                                             type uint8;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ipv4 {
 *                                     leaf ipv4 {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                                 case ipv4-binary {
 *                                     leaf ipv4-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix {
 *                                     leaf ipv4-prefix {
 *                                         type ipv4-prefix;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix-binary {
 *                                     leaf ipv4-address-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                     leaf ipv4-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case ipv6 {
 *                                     leaf ipv6 {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                                 case ipv6-binary {
 *                                     leaf ipv6-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix {
 *                                     leaf ipv6-prefix {
 *                                         type ipv6-prefix;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix-binary {
 *                                     leaf ipv6-address-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                     leaf ipv6-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case key-value-address {
 *                                     container key-value-address {
 *                                         leaf key {
 *                                             type simple-address;
 *                                         }
 *                                         leaf value {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case mac {
 *                                     leaf mac {
 *                                         type mac-address;
 *                                     }
 *                                 }
 *                                 case nat-traversal {
 *                                     container nat-traversal {
 *                                         leaf ms-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf etr-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf global-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf ms-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf private-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf-list rtr-rlocs {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case no-address {
 *                                     leaf no-address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                                 case null-address {
 *                                     container null-address {
 *                                         leaf address {
 *                                             type empty;
 *                                         }
 *                                     }
 *                                 }
 *                                 case service-path {
 *                                     container service-path {
 *                                         leaf service-path-id {
 *                                             type service-path-id-type;
 *                                         }
 *                                         leaf service-index {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                 }
 *                                 case source-dest-key {
 *                                     container source-dest-key {
 *                                         leaf source {
 *                                             type simple-address;
 *                                         }
 *                                         leaf dest {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses augmented-lisp-address;
 *                         }
 *                         list LocatorRecord {
 *                             key "locator-id";
 *                             leaf locator-id {
 *                                 type string;
 *                             }
 *                             leaf priority {
 *                                 type uint8;
 *                             }
 *                             leaf weight {
 *                                 type uint8;
 *                             }
 *                             leaf multicastPriority {
 *                                 type uint8;
 *                             }
 *                             leaf multicastWeight {
 *                                 type uint8;
 *                             }
 *                             leaf localLocator {
 *                                 type boolean;
 *                             }
 *                             leaf rlocProbed {
 *                                 type boolean;
 *                             }
 *                             leaf routed {
 *                                 type boolean;
 *                             }
 *                             container rloc {
 *                                 leaf address-type {
 *                                     type lisp-address-family-ref;
 *                                 }
 *                                 leaf virtual-network-id {
 *                                     type instance-id-type;
 *                                 }
 *                                 choice address {
 *                                     case afi-list {
 *                                         container afi-list {
 *                                             leaf-list address-list {
 *                                                 type simple-address;
 *                                             }
 *                                         }
 *                                     }
 *                                     case application-data {
 *                                         container application-data {
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf protocol {
 *                                                 type uint8;
 *                                             }
 *                                             leaf ip-tos {
 *                                                 type int32;
 *                                             }
 *                                             leaf local-port-low {
 *                                                 type port-number;
 *                                             }
 *                                             leaf local-port-high {
 *                                                 type port-number;
 *                                             }
 *                                             leaf remote-port-low {
 *                                                 type port-number;
 *                                             }
 *                                             leaf remote-port-high {
 *                                                 type port-number;
 *                                             }
 *                                         }
 *                                     }
 *                                     case as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                     }
 *                                     case as-number-lcaf {
 *                                         container as-number-lcaf {
 *                                             leaf as {
 *                                                 type as-number;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                         }
 *                                     }
 *                                     case distinguished-name {
 *                                         leaf distinguished-name {
 *                                             type distinguished-name-type;
 *                                         }
 *                                     }
 *                                     case explicit-locator-path {
 *                                         container explicit-locator-path {
 *                                             list hop {
 *                                                 key "hop-id";
 *                                                 leaf hop-id {
 *                                                     type string;
 *                                                 }
 *                                                 leaf address {
 *                                                     type simple-address;
 *                                                 }
 *                                                 leaf lrs-bits {
 *                                                     type bits;
 *                                                 }
 *                                             }
 *                                         }
 *                                     }
 *                                     case geo-coordinates {
 *                                         container geo-coordinates {
 *                                             leaf latitude {
 *                                                 type bits;
 *                                             }
 *                                             leaf latitude-degrees {
 *                                                 type uint8;
 *                                             }
 *                                             leaf latitude-minutes {
 *                                                 type uint8;
 *                                             }
 *                                             leaf latitude-seconds {
 *                                                 type uint8;
 *                                             }
 *                                             leaf longitude {
 *                                                 type bits;
 *                                             }
 *                                             leaf longitude-degrees {
 *                                                 type uint16;
 *                                             }
 *                                             leaf longitude-minutes {
 *                                                 type uint8;
 *                                             }
 *                                             leaf longitude-seconds {
 *                                                 type uint8;
 *                                             }
 *                                             leaf altitude {
 *                                                 type int32;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                         }
 *                                     }
 *                                     case instance-id {
 *                                         container instance-id {
 *                                             leaf iid {
 *                                                 type instance-id-type;
 *                                             }
 *                                             leaf mask-length {
 *                                                 type uint8;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                         }
 *                                     }
 *                                     case ipv4 {
 *                                         leaf ipv4 {
 *                                             type ipv4-address;
 *                                         }
 *                                     }
 *                                     case ipv4-binary {
 *                                         leaf ipv4-binary {
 *                                             type ipv4-address-binary;
 *                                         }
 *                                     }
 *                                     case ipv4-prefix {
 *                                         leaf ipv4-prefix {
 *                                             type ipv4-prefix;
 *                                         }
 *                                     }
 *                                     case ipv4-prefix-binary {
 *                                         leaf ipv4-address-binary {
 *                                             type ipv4-address-binary;
 *                                         }
 *                                         leaf ipv4-mask-length {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                     case ipv6 {
 *                                         leaf ipv6 {
 *                                             type ipv6-address;
 *                                         }
 *                                     }
 *                                     case ipv6-binary {
 *                                         leaf ipv6-binary {
 *                                             type ipv6-address-binary;
 *                                         }
 *                                     }
 *                                     case ipv6-prefix {
 *                                         leaf ipv6-prefix {
 *                                             type ipv6-prefix;
 *                                         }
 *                                     }
 *                                     case ipv6-prefix-binary {
 *                                         leaf ipv6-address-binary {
 *                                             type ipv6-address-binary;
 *                                         }
 *                                         leaf ipv6-mask-length {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                     case key-value-address {
 *                                         container key-value-address {
 *                                             leaf key {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf value {
 *                                                 type simple-address;
 *                                             }
 *                                         }
 *                                     }
 *                                     case mac {
 *                                         leaf mac {
 *                                             type mac-address;
 *                                         }
 *                                     }
 *                                     case nat-traversal {
 *                                         container nat-traversal {
 *                                             leaf ms-udp-port {
 *                                                 type uint16;
 *                                             }
 *                                             leaf etr-udp-port {
 *                                                 type uint16;
 *                                             }
 *                                             leaf global-etr-rloc {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf ms-rloc {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf private-etr-rloc {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf-list rtr-rlocs {
 *                                                 type simple-address;
 *                                             }
 *                                         }
 *                                     }
 *                                     case no-address {
 *                                         leaf no-address {
 *                                             type empty;
 *                                         }
 *                                     }
 *                                     case null-address {
 *                                         container null-address {
 *                                             leaf address {
 *                                                 type empty;
 *                                             }
 *                                         }
 *                                     }
 *                                     case service-path {
 *                                         container service-path {
 *                                             leaf service-path-id {
 *                                                 type service-path-id-type;
 *                                             }
 *                                             leaf service-index {
 *                                                 type uint8;
 *                                             }
 *                                         }
 *                                     }
 *                                     case source-dest-key {
 *                                         container source-dest-key {
 *                                             leaf source {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf dest {
 *                                                 type simple-address;
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 uses augmented-lisp-address;
 *                             }
 *                             uses rloc-container;
 *                         }
 *                         uses eid-container;
 *                         uses mapping-record-metadata;
 *                         uses LocatorRecords;
 *                     }
 *                     uses mapping-record-container;
 *                 }
 *                 container mapping-record {
 *                     leaf recordTtl {
 *                         type int32;
 *                     }
 *                     leaf mapVersion {
 *                         type int16;
 *                     }
 *                     leaf action {
 *                         type enumeration;
 *                     }
 *                     leaf authoritative {
 *                         type boolean;
 *                     }
 *                     leaf xtr-id {
 *                         type xtr-id;
 *                     }
 *                     leaf site-id {
 *                         type site-id;
 *                     }
 *                     leaf source-rloc {
 *                         type ip-address-binary;
 *                     }
 *                     leaf timestamp {
 *                         type int64;
 *                     }
 *                     container eid {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     list LocatorRecord {
 *                         key "locator-id";
 *                         leaf locator-id {
 *                             type string;
 *                         }
 *                         leaf priority {
 *                             type uint8;
 *                         }
 *                         leaf weight {
 *                             type uint8;
 *                         }
 *                         leaf multicastPriority {
 *                             type uint8;
 *                         }
 *                         leaf multicastWeight {
 *                             type uint8;
 *                         }
 *                         leaf localLocator {
 *                             type boolean;
 *                         }
 *                         leaf rlocProbed {
 *                             type boolean;
 *                         }
 *                         leaf routed {
 *                             type boolean;
 *                         }
 *                         container rloc {
 *                             leaf address-type {
 *                                 type lisp-address-family-ref;
 *                             }
 *                             leaf virtual-network-id {
 *                                 type instance-id-type;
 *                             }
 *                             choice address {
 *                                 case afi-list {
 *                                     container afi-list {
 *                                         leaf-list address-list {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case application-data {
 *                                     container application-data {
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf protocol {
 *                                             type uint8;
 *                                         }
 *                                         leaf ip-tos {
 *                                             type int32;
 *                                         }
 *                                         leaf local-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf local-port-high {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-high {
 *                                             type port-number;
 *                                         }
 *                                     }
 *                                 }
 *                                 case as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                 }
 *                                 case as-number-lcaf {
 *                                     container as-number-lcaf {
 *                                         leaf as {
 *                                             type as-number;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case distinguished-name {
 *                                     leaf distinguished-name {
 *                                         type distinguished-name-type;
 *                                     }
 *                                 }
 *                                 case explicit-locator-path {
 *                                     container explicit-locator-path {
 *                                         list hop {
 *                                             key "hop-id";
 *                                             leaf hop-id {
 *                                                 type string;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf lrs-bits {
 *                                                 type bits;
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 case geo-coordinates {
 *                                     container geo-coordinates {
 *                                         leaf latitude {
 *                                             type bits;
 *                                         }
 *                                         leaf latitude-degrees {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude {
 *                                             type bits;
 *                                         }
 *                                         leaf longitude-degrees {
 *                                             type uint16;
 *                                         }
 *                                         leaf longitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf altitude {
 *                                             type int32;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case instance-id {
 *                                     container instance-id {
 *                                         leaf iid {
 *                                             type instance-id-type;
 *                                         }
 *                                         leaf mask-length {
 *                                             type uint8;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ipv4 {
 *                                     leaf ipv4 {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                                 case ipv4-binary {
 *                                     leaf ipv4-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix {
 *                                     leaf ipv4-prefix {
 *                                         type ipv4-prefix;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix-binary {
 *                                     leaf ipv4-address-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                     leaf ipv4-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case ipv6 {
 *                                     leaf ipv6 {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                                 case ipv6-binary {
 *                                     leaf ipv6-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix {
 *                                     leaf ipv6-prefix {
 *                                         type ipv6-prefix;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix-binary {
 *                                     leaf ipv6-address-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                     leaf ipv6-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case key-value-address {
 *                                     container key-value-address {
 *                                         leaf key {
 *                                             type simple-address;
 *                                         }
 *                                         leaf value {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case mac {
 *                                     leaf mac {
 *                                         type mac-address;
 *                                     }
 *                                 }
 *                                 case nat-traversal {
 *                                     container nat-traversal {
 *                                         leaf ms-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf etr-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf global-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf ms-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf private-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf-list rtr-rlocs {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case no-address {
 *                                     leaf no-address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                                 case null-address {
 *                                     container null-address {
 *                                         leaf address {
 *                                             type empty;
 *                                         }
 *                                     }
 *                                 }
 *                                 case service-path {
 *                                     container service-path {
 *                                         leaf service-path-id {
 *                                             type service-path-id-type;
 *                                         }
 *                                         leaf service-index {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                 }
 *                                 case source-dest-key {
 *                                     container source-dest-key {
 *                                         leaf source {
 *                                             type simple-address;
 *                                         }
 *                                         leaf dest {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses augmented-lisp-address;
 *                         }
 *                         uses rloc-container;
 *                     }
 *                     uses eid-container;
 *                     uses mapping-record-metadata;
 *                     uses LocatorRecords;
 *                 }
 *                 uses mapping-record-container;
 *             }
 *             list authentication-key {
 *                 key "eid-uri";
 *                 leaf eid-uri {
 *                     type eid-uri;
 *                 }
 *                 container mapping-authkey {
 *                     leaf key-string {
 *                         type string;
 *                     }
 *                     leaf key-type {
 *                         type uint16;
 *                     }
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-authkey-container;
 *             }
 *             uses db-instance;
 *         }
 *         container last-updated {
 *             leaf last-updated {
 *                 type int64;
 *             }
 *         }
 *     }
 *
 *     grouping eid-authkey-list {
 *         list eid-authkey-item {
 *             key "eid-authkey-item-id";
 *             leaf eid-authkey-item-id {
 *                 type string;
 *             }
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *             container mapping-authkey {
 *                 leaf key-string {
 *                     type string;
 *                 }
 *                 leaf key-type {
 *                     type uint16;
 *                 }
 *             }
 *             uses eid-container;
 *             uses mapping-authkey-container;
 *         }
 *     }
 *     grouping db-instance {
 *         leaf vni {
 *             type vni-uri;
 *         }
 *         list mapping {
 *             key "eid-uri" "origin";
 *             leaf eid-uri {
 *                 type eid-uri;
 *             }
 *             leaf origin {
 *                 type mapping-origin;
 *             }
 *             leaf-list site-id {
 *                 type site-id;
 *             }
 *             container mapping-record {
 *                 leaf recordTtl {
 *                     type int32;
 *                 }
 *                 leaf mapVersion {
 *                     type int16;
 *                 }
 *                 leaf action {
 *                     type enumeration;
 *                 }
 *                 leaf authoritative {
 *                     type boolean;
 *                 }
 *                 leaf xtr-id {
 *                     type xtr-id;
 *                 }
 *                 leaf site-id {
 *                     type site-id;
 *                 }
 *                 leaf source-rloc {
 *                     type ip-address-binary;
 *                 }
 *                 leaf timestamp {
 *                     type int64;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 list LocatorRecord {
 *                     key "locator-id";
 *                     leaf locator-id {
 *                         type string;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf weight {
 *                         type uint8;
 *                     }
 *                     leaf multicastPriority {
 *                         type uint8;
 *                     }
 *                     leaf multicastWeight {
 *                         type uint8;
 *                     }
 *                     leaf localLocator {
 *                         type boolean;
 *                     }
 *                     leaf rlocProbed {
 *                         type boolean;
 *                     }
 *                     leaf routed {
 *                         type boolean;
 *                     }
 *                     container rloc {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     uses rloc-container;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-record-metadata;
 *                 uses LocatorRecords;
 *             }
 *             list xtr-id-mapping {
 *                 key "xtr-id-uri";
 *                 leaf xtr-id-uri {
 *                     type xtr-id-uri;
 *                 }
 *                 container mapping-record {
 *                     leaf recordTtl {
 *                         type int32;
 *                     }
 *                     leaf mapVersion {
 *                         type int16;
 *                     }
 *                     leaf action {
 *                         type enumeration;
 *                     }
 *                     leaf authoritative {
 *                         type boolean;
 *                     }
 *                     leaf xtr-id {
 *                         type xtr-id;
 *                     }
 *                     leaf site-id {
 *                         type site-id;
 *                     }
 *                     leaf source-rloc {
 *                         type ip-address-binary;
 *                     }
 *                     leaf timestamp {
 *                         type int64;
 *                     }
 *                     container eid {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     list LocatorRecord {
 *                         key "locator-id";
 *                         leaf locator-id {
 *                             type string;
 *                         }
 *                         leaf priority {
 *                             type uint8;
 *                         }
 *                         leaf weight {
 *                             type uint8;
 *                         }
 *                         leaf multicastPriority {
 *                             type uint8;
 *                         }
 *                         leaf multicastWeight {
 *                             type uint8;
 *                         }
 *                         leaf localLocator {
 *                             type boolean;
 *                         }
 *                         leaf rlocProbed {
 *                             type boolean;
 *                         }
 *                         leaf routed {
 *                             type boolean;
 *                         }
 *                         container rloc {
 *                             leaf address-type {
 *                                 type lisp-address-family-ref;
 *                             }
 *                             leaf virtual-network-id {
 *                                 type instance-id-type;
 *                             }
 *                             choice address {
 *                                 case afi-list {
 *                                     container afi-list {
 *                                         leaf-list address-list {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case application-data {
 *                                     container application-data {
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf protocol {
 *                                             type uint8;
 *                                         }
 *                                         leaf ip-tos {
 *                                             type int32;
 *                                         }
 *                                         leaf local-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf local-port-high {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-high {
 *                                             type port-number;
 *                                         }
 *                                     }
 *                                 }
 *                                 case as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                 }
 *                                 case as-number-lcaf {
 *                                     container as-number-lcaf {
 *                                         leaf as {
 *                                             type as-number;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case distinguished-name {
 *                                     leaf distinguished-name {
 *                                         type distinguished-name-type;
 *                                     }
 *                                 }
 *                                 case explicit-locator-path {
 *                                     container explicit-locator-path {
 *                                         list hop {
 *                                             key "hop-id";
 *                                             leaf hop-id {
 *                                                 type string;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf lrs-bits {
 *                                                 type bits;
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 case geo-coordinates {
 *                                     container geo-coordinates {
 *                                         leaf latitude {
 *                                             type bits;
 *                                         }
 *                                         leaf latitude-degrees {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude {
 *                                             type bits;
 *                                         }
 *                                         leaf longitude-degrees {
 *                                             type uint16;
 *                                         }
 *                                         leaf longitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf altitude {
 *                                             type int32;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case instance-id {
 *                                     container instance-id {
 *                                         leaf iid {
 *                                             type instance-id-type;
 *                                         }
 *                                         leaf mask-length {
 *                                             type uint8;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ipv4 {
 *                                     leaf ipv4 {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                                 case ipv4-binary {
 *                                     leaf ipv4-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix {
 *                                     leaf ipv4-prefix {
 *                                         type ipv4-prefix;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix-binary {
 *                                     leaf ipv4-address-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                     leaf ipv4-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case ipv6 {
 *                                     leaf ipv6 {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                                 case ipv6-binary {
 *                                     leaf ipv6-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix {
 *                                     leaf ipv6-prefix {
 *                                         type ipv6-prefix;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix-binary {
 *                                     leaf ipv6-address-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                     leaf ipv6-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case key-value-address {
 *                                     container key-value-address {
 *                                         leaf key {
 *                                             type simple-address;
 *                                         }
 *                                         leaf value {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case mac {
 *                                     leaf mac {
 *                                         type mac-address;
 *                                     }
 *                                 }
 *                                 case nat-traversal {
 *                                     container nat-traversal {
 *                                         leaf ms-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf etr-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf global-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf ms-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf private-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf-list rtr-rlocs {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case no-address {
 *                                     leaf no-address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                                 case null-address {
 *                                     container null-address {
 *                                         leaf address {
 *                                             type empty;
 *                                         }
 *                                     }
 *                                 }
 *                                 case service-path {
 *                                     container service-path {
 *                                         leaf service-path-id {
 *                                             type service-path-id-type;
 *                                         }
 *                                         leaf service-index {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                 }
 *                                 case source-dest-key {
 *                                     container source-dest-key {
 *                                         leaf source {
 *                                             type simple-address;
 *                                         }
 *                                         leaf dest {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses augmented-lisp-address;
 *                         }
 *                         uses rloc-container;
 *                     }
 *                     uses eid-container;
 *                     uses mapping-record-metadata;
 *                     uses LocatorRecords;
 *                 }
 *                 uses mapping-record-container;
 *             }
 *             uses mapping-record-container;
 *         }
 *         list authentication-key {
 *             key "eid-uri";
 *             leaf eid-uri {
 *                 type eid-uri;
 *             }
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *             container mapping-authkey {
 *                 leaf key-string {
 *                     type string;
 *                 }
 *                 leaf key-type {
 *                     type uint16;
 *                 }
 *             }
 *             uses eid-container;
 *             uses mapping-authkey-container;
 *         }
 *     }
 *     grouping mapping-authkey-list {
 *         list mapping-authkey-item {
 *             key "mapping-authkey-item-id";
 *             leaf mapping-authkey-item-id {
 *                 type string;
 *             }
 *             container mapping-authkey {
 *                 leaf key-string {
 *                     type string;
 *                 }
 *                 leaf key-type {
 *                     type uint16;
 *                 }
 *             }
 *             uses mapping-authkey-container;
 *         }
 *     }
 *
 *     identity xtrid-context {
 *         description
 *             "A classifier for xtr-id elements which allows direct access to a particular element in the data tree.";
 *         status CURRENT;
 *     }
 *     identity vni-context {
 *         description
 *             "A classifier for virtual-network-identifier elements which allows direct access to a particular element in the data tree.";
 *         status CURRENT;
 *     }
 *     identity eid-context {
 *         description
 *             "A classifier for endpoint-id elements which allows direct access to a particular element in the data tree.";
 *         status CURRENT;
 *     }
 *
 *     notification mapping-changed {
 *         description
 *             "Notification sent when a mapping is changed";
 *         leaf change-type {
 *             type mapping-change;
 *         }
 *         container mapping-record {
 *             leaf recordTtl {
 *                 type int32;
 *             }
 *             leaf mapVersion {
 *                 type int16;
 *             }
 *             leaf action {
 *                 type enumeration;
 *             }
 *             leaf authoritative {
 *                 type boolean;
 *             }
 *             leaf xtr-id {
 *                 type xtr-id;
 *             }
 *             leaf site-id {
 *                 type site-id;
 *             }
 *             leaf source-rloc {
 *                 type ip-address-binary;
 *             }
 *             leaf timestamp {
 *                 type int64;
 *             }
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *             list LocatorRecord {
 *                 key "locator-id";
 *                 leaf locator-id {
 *                     type string;
 *                 }
 *                 leaf priority {
 *                     type uint8;
 *                 }
 *                 leaf weight {
 *                     type uint8;
 *                 }
 *                 leaf multicastPriority {
 *                     type uint8;
 *                 }
 *                 leaf multicastWeight {
 *                     type uint8;
 *                 }
 *                 leaf localLocator {
 *                     type boolean;
 *                 }
 *                 leaf rlocProbed {
 *                     type boolean;
 *                 }
 *                 leaf routed {
 *                     type boolean;
 *                 }
 *                 container rloc {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses rloc-container;
 *             }
 *             uses eid-container;
 *             uses mapping-record-metadata;
 *             uses LocatorRecords;
 *         }
 *         container eid {
 *             leaf address-type {
 *                 type lisp-address-family-ref;
 *             }
 *             leaf virtual-network-id {
 *                 type instance-id-type;
 *             }
 *             choice address {
 *                 case afi-list {
 *                     container afi-list {
 *                         leaf-list address-list {
 *                             type simple-address;
 *                         }
 *                     }
 *                 }
 *                 case application-data {
 *                     container application-data {
 *                         leaf address {
 *                             type simple-address;
 *                         }
 *                         leaf protocol {
 *                             type uint8;
 *                         }
 *                         leaf ip-tos {
 *                             type int32;
 *                         }
 *                         leaf local-port-low {
 *                             type port-number;
 *                         }
 *                         leaf local-port-high {
 *                             type port-number;
 *                         }
 *                         leaf remote-port-low {
 *                             type port-number;
 *                         }
 *                         leaf remote-port-high {
 *                             type port-number;
 *                         }
 *                     }
 *                 }
 *                 case as-number {
 *                     leaf as-number {
 *                         type as-number;
 *                     }
 *                 }
 *                 case as-number-lcaf {
 *                     container as-number-lcaf {
 *                         leaf as {
 *                             type as-number;
 *                         }
 *                         leaf address {
 *                             type simple-address;
 *                         }
 *                     }
 *                 }
 *                 case distinguished-name {
 *                     leaf distinguished-name {
 *                         type distinguished-name-type;
 *                     }
 *                 }
 *                 case explicit-locator-path {
 *                     container explicit-locator-path {
 *                         list hop {
 *                             key "hop-id";
 *                             leaf hop-id {
 *                                 type string;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf lrs-bits {
 *                                 type bits;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 case geo-coordinates {
 *                     container geo-coordinates {
 *                         leaf latitude {
 *                             type bits;
 *                         }
 *                         leaf latitude-degrees {
 *                             type uint8;
 *                         }
 *                         leaf latitude-minutes {
 *                             type uint8;
 *                         }
 *                         leaf latitude-seconds {
 *                             type uint8;
 *                         }
 *                         leaf longitude {
 *                             type bits;
 *                         }
 *                         leaf longitude-degrees {
 *                             type uint16;
 *                         }
 *                         leaf longitude-minutes {
 *                             type uint8;
 *                         }
 *                         leaf longitude-seconds {
 *                             type uint8;
 *                         }
 *                         leaf altitude {
 *                             type int32;
 *                         }
 *                         leaf address {
 *                             type simple-address;
 *                         }
 *                     }
 *                 }
 *                 case instance-id {
 *                     container instance-id {
 *                         leaf iid {
 *                             type instance-id-type;
 *                         }
 *                         leaf mask-length {
 *                             type uint8;
 *                         }
 *                         leaf address {
 *                             type simple-address;
 *                         }
 *                     }
 *                 }
 *                 case ipv4 {
 *                     leaf ipv4 {
 *                         type ipv4-address;
 *                     }
 *                 }
 *                 case ipv4-binary {
 *                     leaf ipv4-binary {
 *                         type ipv4-address-binary;
 *                     }
 *                 }
 *                 case ipv4-prefix {
 *                     leaf ipv4-prefix {
 *                         type ipv4-prefix;
 *                     }
 *                 }
 *                 case ipv4-prefix-binary {
 *                     leaf ipv4-address-binary {
 *                         type ipv4-address-binary;
 *                     }
 *                     leaf ipv4-mask-length {
 *                         type uint8;
 *                     }
 *                 }
 *                 case ipv6 {
 *                     leaf ipv6 {
 *                         type ipv6-address;
 *                     }
 *                 }
 *                 case ipv6-binary {
 *                     leaf ipv6-binary {
 *                         type ipv6-address-binary;
 *                     }
 *                 }
 *                 case ipv6-prefix {
 *                     leaf ipv6-prefix {
 *                         type ipv6-prefix;
 *                     }
 *                 }
 *                 case ipv6-prefix-binary {
 *                     leaf ipv6-address-binary {
 *                         type ipv6-address-binary;
 *                     }
 *                     leaf ipv6-mask-length {
 *                         type uint8;
 *                     }
 *                 }
 *                 case key-value-address {
 *                     container key-value-address {
 *                         leaf key {
 *                             type simple-address;
 *                         }
 *                         leaf value {
 *                             type simple-address;
 *                         }
 *                     }
 *                 }
 *                 case mac {
 *                     leaf mac {
 *                         type mac-address;
 *                     }
 *                 }
 *                 case nat-traversal {
 *                     container nat-traversal {
 *                         leaf ms-udp-port {
 *                             type uint16;
 *                         }
 *                         leaf etr-udp-port {
 *                             type uint16;
 *                         }
 *                         leaf global-etr-rloc {
 *                             type simple-address;
 *                         }
 *                         leaf ms-rloc {
 *                             type simple-address;
 *                         }
 *                         leaf private-etr-rloc {
 *                             type simple-address;
 *                         }
 *                         leaf-list rtr-rlocs {
 *                             type simple-address;
 *                         }
 *                     }
 *                 }
 *                 case no-address {
 *                     leaf no-address {
 *                         type empty;
 *                     }
 *                 }
 *                 case null-address {
 *                     container null-address {
 *                         leaf address {
 *                             type empty;
 *                         }
 *                     }
 *                 }
 *                 case service-path {
 *                     container service-path {
 *                         leaf service-path-id {
 *                             type service-path-id-type;
 *                         }
 *                         leaf service-index {
 *                             type uint8;
 *                         }
 *                     }
 *                 }
 *                 case source-dest-key {
 *                     container source-dest-key {
 *                         leaf source {
 *                             type simple-address;
 *                         }
 *                         leaf dest {
 *                             type simple-address;
 *                         }
 *                     }
 *                 }
 *             }
 *             uses augmented-lisp-address;
 *         }
 *         list subscriber-item {
 *             container subscriber-data {
 *                 leaf ttl {
 *                     type int32;
 *                 }
 *                 container rloc {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses rloc-container;
 *                 uses eid-container;
 *             }
 *             uses subscriber-data-grouping;
 *         }
 *         list dst-subscriber-item {
 *             container subscriber-data {
 *                 leaf ttl {
 *                     type int32;
 *                 }
 *                 container rloc {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses rloc-container;
 *                 uses eid-container;
 *             }
 *             uses subscriber-data-grouping;
 *         }
 *         uses eid-container;
 *         uses mapping-record-container;
 *     }
 *
 *     rpc remove-all-mappings {
 *         input {
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc get-all-keys {
 *         input {
 *         }
 *         
 *         output {
 *             list eid-authkey-item {
 *                 key "eid-authkey-item-id";
 *                 leaf eid-authkey-item-id {
 *                     type string;
 *                 }
 *                 container mapping-authkey {
 *                     leaf key-string {
 *                         type string;
 *                     }
 *                     leaf key-type {
 *                         type uint16;
 *                     }
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-authkey-container;
 *             }
 *         }
 *     }
 *     rpc remove-all-keys {
 *         input {
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc get-mapping-with-xtr-id {
 *         input {
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *             leaf xtr-id {
 *                 type xtr-id;
 *             }
 *         }
 *         
 *         output {
 *             container mapping-record {
 *                 leaf recordTtl {
 *                     type int32;
 *                 }
 *                 leaf mapVersion {
 *                     type int16;
 *                 }
 *                 leaf action {
 *                     type enumeration;
 *                 }
 *                 leaf authoritative {
 *                     type boolean;
 *                 }
 *                 leaf xtr-id {
 *                     type xtr-id;
 *                 }
 *                 leaf site-id {
 *                     type site-id;
 *                 }
 *                 leaf source-rloc {
 *                     type ip-address-binary;
 *                 }
 *                 leaf timestamp {
 *                     type int64;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 list LocatorRecord {
 *                     key "locator-id";
 *                     leaf locator-id {
 *                         type string;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf weight {
 *                         type uint8;
 *                     }
 *                     leaf multicastPriority {
 *                         type uint8;
 *                     }
 *                     leaf multicastWeight {
 *                         type uint8;
 *                     }
 *                     leaf localLocator {
 *                         type boolean;
 *                     }
 *                     leaf rlocProbed {
 *                         type boolean;
 *                     }
 *                     leaf routed {
 *                         type boolean;
 *                     }
 *                     container rloc {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     uses rloc-container;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-record-metadata;
 *                 uses LocatorRecords;
 *             }
 *         }
 *     }
 *     rpc update-key {
 *         input {
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *             container mapping-authkey {
 *                 leaf key-string {
 *                     type string;
 *                 }
 *                 leaf key-type {
 *                     type uint16;
 *                 }
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc get-mapping {
 *         input {
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *         }
 *         
 *         output {
 *             container mapping-record {
 *                 leaf recordTtl {
 *                     type int32;
 *                 }
 *                 leaf mapVersion {
 *                     type int16;
 *                 }
 *                 leaf action {
 *                     type enumeration;
 *                 }
 *                 leaf authoritative {
 *                     type boolean;
 *                 }
 *                 leaf xtr-id {
 *                     type xtr-id;
 *                 }
 *                 leaf site-id {
 *                     type site-id;
 *                 }
 *                 leaf source-rloc {
 *                     type ip-address-binary;
 *                 }
 *                 leaf timestamp {
 *                     type int64;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 list LocatorRecord {
 *                     key "locator-id";
 *                     leaf locator-id {
 *                         type string;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf weight {
 *                         type uint8;
 *                     }
 *                     leaf multicastPriority {
 *                         type uint8;
 *                     }
 *                     leaf multicastWeight {
 *                         type uint8;
 *                     }
 *                     leaf localLocator {
 *                         type boolean;
 *                     }
 *                     leaf rlocProbed {
 *                         type boolean;
 *                     }
 *                     leaf routed {
 *                         type boolean;
 *                     }
 *                     container rloc {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     uses rloc-container;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-record-metadata;
 *                 uses LocatorRecords;
 *             }
 *         }
 *     }
 *     rpc get-mappings {
 *         input {
 *             list eid-item {
 *                 key "eid-item-id";
 *                 leaf eid-item-id {
 *                     type string;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *             }
 *         }
 *         
 *         output {
 *             list mapping-record-item {
 *                 key "mapping-record-item-id";
 *                 leaf mapping-record-item-id {
 *                     type string;
 *                 }
 *                 container mapping-record {
 *                     leaf recordTtl {
 *                         type int32;
 *                     }
 *                     leaf mapVersion {
 *                         type int16;
 *                     }
 *                     leaf action {
 *                         type enumeration;
 *                     }
 *                     leaf authoritative {
 *                         type boolean;
 *                     }
 *                     leaf xtr-id {
 *                         type xtr-id;
 *                     }
 *                     leaf site-id {
 *                         type site-id;
 *                     }
 *                     leaf source-rloc {
 *                         type ip-address-binary;
 *                     }
 *                     leaf timestamp {
 *                         type int64;
 *                     }
 *                     container eid {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     list LocatorRecord {
 *                         key "locator-id";
 *                         leaf locator-id {
 *                             type string;
 *                         }
 *                         leaf priority {
 *                             type uint8;
 *                         }
 *                         leaf weight {
 *                             type uint8;
 *                         }
 *                         leaf multicastPriority {
 *                             type uint8;
 *                         }
 *                         leaf multicastWeight {
 *                             type uint8;
 *                         }
 *                         leaf localLocator {
 *                             type boolean;
 *                         }
 *                         leaf rlocProbed {
 *                             type boolean;
 *                         }
 *                         leaf routed {
 *                             type boolean;
 *                         }
 *                         container rloc {
 *                             leaf address-type {
 *                                 type lisp-address-family-ref;
 *                             }
 *                             leaf virtual-network-id {
 *                                 type instance-id-type;
 *                             }
 *                             choice address {
 *                                 case afi-list {
 *                                     container afi-list {
 *                                         leaf-list address-list {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case application-data {
 *                                     container application-data {
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf protocol {
 *                                             type uint8;
 *                                         }
 *                                         leaf ip-tos {
 *                                             type int32;
 *                                         }
 *                                         leaf local-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf local-port-high {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-high {
 *                                             type port-number;
 *                                         }
 *                                     }
 *                                 }
 *                                 case as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                 }
 *                                 case as-number-lcaf {
 *                                     container as-number-lcaf {
 *                                         leaf as {
 *                                             type as-number;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case distinguished-name {
 *                                     leaf distinguished-name {
 *                                         type distinguished-name-type;
 *                                     }
 *                                 }
 *                                 case explicit-locator-path {
 *                                     container explicit-locator-path {
 *                                         list hop {
 *                                             key "hop-id";
 *                                             leaf hop-id {
 *                                                 type string;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf lrs-bits {
 *                                                 type bits;
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 case geo-coordinates {
 *                                     container geo-coordinates {
 *                                         leaf latitude {
 *                                             type bits;
 *                                         }
 *                                         leaf latitude-degrees {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude {
 *                                             type bits;
 *                                         }
 *                                         leaf longitude-degrees {
 *                                             type uint16;
 *                                         }
 *                                         leaf longitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf altitude {
 *                                             type int32;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case instance-id {
 *                                     container instance-id {
 *                                         leaf iid {
 *                                             type instance-id-type;
 *                                         }
 *                                         leaf mask-length {
 *                                             type uint8;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ipv4 {
 *                                     leaf ipv4 {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                                 case ipv4-binary {
 *                                     leaf ipv4-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix {
 *                                     leaf ipv4-prefix {
 *                                         type ipv4-prefix;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix-binary {
 *                                     leaf ipv4-address-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                     leaf ipv4-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case ipv6 {
 *                                     leaf ipv6 {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                                 case ipv6-binary {
 *                                     leaf ipv6-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix {
 *                                     leaf ipv6-prefix {
 *                                         type ipv6-prefix;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix-binary {
 *                                     leaf ipv6-address-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                     leaf ipv6-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case key-value-address {
 *                                     container key-value-address {
 *                                         leaf key {
 *                                             type simple-address;
 *                                         }
 *                                         leaf value {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case mac {
 *                                     leaf mac {
 *                                         type mac-address;
 *                                     }
 *                                 }
 *                                 case nat-traversal {
 *                                     container nat-traversal {
 *                                         leaf ms-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf etr-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf global-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf ms-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf private-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf-list rtr-rlocs {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case no-address {
 *                                     leaf no-address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                                 case null-address {
 *                                     container null-address {
 *                                         leaf address {
 *                                             type empty;
 *                                         }
 *                                     }
 *                                 }
 *                                 case service-path {
 *                                     container service-path {
 *                                         leaf service-path-id {
 *                                             type service-path-id-type;
 *                                         }
 *                                         leaf service-index {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                 }
 *                                 case source-dest-key {
 *                                     container source-dest-key {
 *                                         leaf source {
 *                                             type simple-address;
 *                                         }
 *                                         leaf dest {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses augmented-lisp-address;
 *                         }
 *                         uses rloc-container;
 *                     }
 *                     uses eid-container;
 *                     uses mapping-record-metadata;
 *                     uses LocatorRecords;
 *                 }
 *                 uses mapping-record-container;
 *             }
 *         }
 *     }
 *     rpc get-keys {
 *         input {
 *             list eid-item {
 *                 key "eid-item-id";
 *                 leaf eid-item-id {
 *                     type string;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *             }
 *         }
 *         
 *         output {
 *             list eid-authkey-item {
 *                 key "eid-authkey-item-id";
 *                 leaf eid-authkey-item-id {
 *                     type string;
 *                 }
 *                 container mapping-authkey {
 *                     leaf key-string {
 *                         type string;
 *                     }
 *                     leaf key-type {
 *                         type uint16;
 *                     }
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-authkey-container;
 *             }
 *         }
 *     }
 *     rpc remove-mappings {
 *         input {
 *             list eid-item {
 *                 key "eid-item-id";
 *                 leaf eid-item-id {
 *                     type string;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc get-key {
 *         input {
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *         }
 *         
 *         output {
 *             container mapping-authkey {
 *                 leaf key-string {
 *                     type string;
 *                 }
 *                 leaf key-type {
 *                     type uint16;
 *                 }
 *             }
 *         }
 *     }
 *     rpc remove-keys {
 *         input {
 *             list eid-item {
 *                 key "eid-item-id";
 *                 leaf eid-item-id {
 *                     type string;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc get-all-mappings {
 *         input {
 *         }
 *         
 *         output {
 *             list mapping-record-item {
 *                 key "mapping-record-item-id";
 *                 leaf mapping-record-item-id {
 *                     type string;
 *                 }
 *                 container mapping-record {
 *                     leaf recordTtl {
 *                         type int32;
 *                     }
 *                     leaf mapVersion {
 *                         type int16;
 *                     }
 *                     leaf action {
 *                         type enumeration;
 *                     }
 *                     leaf authoritative {
 *                         type boolean;
 *                     }
 *                     leaf xtr-id {
 *                         type xtr-id;
 *                     }
 *                     leaf site-id {
 *                         type site-id;
 *                     }
 *                     leaf source-rloc {
 *                         type ip-address-binary;
 *                     }
 *                     leaf timestamp {
 *                         type int64;
 *                     }
 *                     container eid {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     list LocatorRecord {
 *                         key "locator-id";
 *                         leaf locator-id {
 *                             type string;
 *                         }
 *                         leaf priority {
 *                             type uint8;
 *                         }
 *                         leaf weight {
 *                             type uint8;
 *                         }
 *                         leaf multicastPriority {
 *                             type uint8;
 *                         }
 *                         leaf multicastWeight {
 *                             type uint8;
 *                         }
 *                         leaf localLocator {
 *                             type boolean;
 *                         }
 *                         leaf rlocProbed {
 *                             type boolean;
 *                         }
 *                         leaf routed {
 *                             type boolean;
 *                         }
 *                         container rloc {
 *                             leaf address-type {
 *                                 type lisp-address-family-ref;
 *                             }
 *                             leaf virtual-network-id {
 *                                 type instance-id-type;
 *                             }
 *                             choice address {
 *                                 case afi-list {
 *                                     container afi-list {
 *                                         leaf-list address-list {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case application-data {
 *                                     container application-data {
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf protocol {
 *                                             type uint8;
 *                                         }
 *                                         leaf ip-tos {
 *                                             type int32;
 *                                         }
 *                                         leaf local-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf local-port-high {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-high {
 *                                             type port-number;
 *                                         }
 *                                     }
 *                                 }
 *                                 case as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                 }
 *                                 case as-number-lcaf {
 *                                     container as-number-lcaf {
 *                                         leaf as {
 *                                             type as-number;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case distinguished-name {
 *                                     leaf distinguished-name {
 *                                         type distinguished-name-type;
 *                                     }
 *                                 }
 *                                 case explicit-locator-path {
 *                                     container explicit-locator-path {
 *                                         list hop {
 *                                             key "hop-id";
 *                                             leaf hop-id {
 *                                                 type string;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf lrs-bits {
 *                                                 type bits;
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 case geo-coordinates {
 *                                     container geo-coordinates {
 *                                         leaf latitude {
 *                                             type bits;
 *                                         }
 *                                         leaf latitude-degrees {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude {
 *                                             type bits;
 *                                         }
 *                                         leaf longitude-degrees {
 *                                             type uint16;
 *                                         }
 *                                         leaf longitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf altitude {
 *                                             type int32;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case instance-id {
 *                                     container instance-id {
 *                                         leaf iid {
 *                                             type instance-id-type;
 *                                         }
 *                                         leaf mask-length {
 *                                             type uint8;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ipv4 {
 *                                     leaf ipv4 {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                                 case ipv4-binary {
 *                                     leaf ipv4-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix {
 *                                     leaf ipv4-prefix {
 *                                         type ipv4-prefix;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix-binary {
 *                                     leaf ipv4-address-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                     leaf ipv4-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case ipv6 {
 *                                     leaf ipv6 {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                                 case ipv6-binary {
 *                                     leaf ipv6-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix {
 *                                     leaf ipv6-prefix {
 *                                         type ipv6-prefix;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix-binary {
 *                                     leaf ipv6-address-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                     leaf ipv6-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case key-value-address {
 *                                     container key-value-address {
 *                                         leaf key {
 *                                             type simple-address;
 *                                         }
 *                                         leaf value {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case mac {
 *                                     leaf mac {
 *                                         type mac-address;
 *                                     }
 *                                 }
 *                                 case nat-traversal {
 *                                     container nat-traversal {
 *                                         leaf ms-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf etr-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf global-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf ms-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf private-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf-list rtr-rlocs {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case no-address {
 *                                     leaf no-address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                                 case null-address {
 *                                     container null-address {
 *                                         leaf address {
 *                                             type empty;
 *                                         }
 *                                     }
 *                                 }
 *                                 case service-path {
 *                                     container service-path {
 *                                         leaf service-path-id {
 *                                             type service-path-id-type;
 *                                         }
 *                                         leaf service-index {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                 }
 *                                 case source-dest-key {
 *                                     container source-dest-key {
 *                                         leaf source {
 *                                             type simple-address;
 *                                         }
 *                                         leaf dest {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses augmented-lisp-address;
 *                         }
 *                         uses rloc-container;
 *                     }
 *                     uses eid-container;
 *                     uses mapping-record-metadata;
 *                     uses LocatorRecords;
 *                 }
 *                 uses mapping-record-container;
 *             }
 *         }
 *     }
 *     rpc add-keys {
 *         input {
 *             list eid-authkey-item {
 *                 key "eid-authkey-item-id";
 *                 leaf eid-authkey-item-id {
 *                     type string;
 *                 }
 *                 container mapping-authkey {
 *                     leaf key-string {
 *                         type string;
 *                     }
 *                     leaf key-type {
 *                         type uint16;
 *                     }
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-authkey-container;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc remove-key {
 *         input {
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc update-mappings {
 *         input {
 *             list mapping-record-item {
 *                 key "mapping-record-item-id";
 *                 leaf mapping-record-item-id {
 *                     type string;
 *                 }
 *                 container mapping-record {
 *                     leaf recordTtl {
 *                         type int32;
 *                     }
 *                     leaf mapVersion {
 *                         type int16;
 *                     }
 *                     leaf action {
 *                         type enumeration;
 *                     }
 *                     leaf authoritative {
 *                         type boolean;
 *                     }
 *                     leaf xtr-id {
 *                         type xtr-id;
 *                     }
 *                     leaf site-id {
 *                         type site-id;
 *                     }
 *                     leaf source-rloc {
 *                         type ip-address-binary;
 *                     }
 *                     leaf timestamp {
 *                         type int64;
 *                     }
 *                     container eid {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     list LocatorRecord {
 *                         key "locator-id";
 *                         leaf locator-id {
 *                             type string;
 *                         }
 *                         leaf priority {
 *                             type uint8;
 *                         }
 *                         leaf weight {
 *                             type uint8;
 *                         }
 *                         leaf multicastPriority {
 *                             type uint8;
 *                         }
 *                         leaf multicastWeight {
 *                             type uint8;
 *                         }
 *                         leaf localLocator {
 *                             type boolean;
 *                         }
 *                         leaf rlocProbed {
 *                             type boolean;
 *                         }
 *                         leaf routed {
 *                             type boolean;
 *                         }
 *                         container rloc {
 *                             leaf address-type {
 *                                 type lisp-address-family-ref;
 *                             }
 *                             leaf virtual-network-id {
 *                                 type instance-id-type;
 *                             }
 *                             choice address {
 *                                 case afi-list {
 *                                     container afi-list {
 *                                         leaf-list address-list {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case application-data {
 *                                     container application-data {
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf protocol {
 *                                             type uint8;
 *                                         }
 *                                         leaf ip-tos {
 *                                             type int32;
 *                                         }
 *                                         leaf local-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf local-port-high {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-high {
 *                                             type port-number;
 *                                         }
 *                                     }
 *                                 }
 *                                 case as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                 }
 *                                 case as-number-lcaf {
 *                                     container as-number-lcaf {
 *                                         leaf as {
 *                                             type as-number;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case distinguished-name {
 *                                     leaf distinguished-name {
 *                                         type distinguished-name-type;
 *                                     }
 *                                 }
 *                                 case explicit-locator-path {
 *                                     container explicit-locator-path {
 *                                         list hop {
 *                                             key "hop-id";
 *                                             leaf hop-id {
 *                                                 type string;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf lrs-bits {
 *                                                 type bits;
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 case geo-coordinates {
 *                                     container geo-coordinates {
 *                                         leaf latitude {
 *                                             type bits;
 *                                         }
 *                                         leaf latitude-degrees {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude {
 *                                             type bits;
 *                                         }
 *                                         leaf longitude-degrees {
 *                                             type uint16;
 *                                         }
 *                                         leaf longitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf altitude {
 *                                             type int32;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case instance-id {
 *                                     container instance-id {
 *                                         leaf iid {
 *                                             type instance-id-type;
 *                                         }
 *                                         leaf mask-length {
 *                                             type uint8;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ipv4 {
 *                                     leaf ipv4 {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                                 case ipv4-binary {
 *                                     leaf ipv4-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix {
 *                                     leaf ipv4-prefix {
 *                                         type ipv4-prefix;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix-binary {
 *                                     leaf ipv4-address-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                     leaf ipv4-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case ipv6 {
 *                                     leaf ipv6 {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                                 case ipv6-binary {
 *                                     leaf ipv6-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix {
 *                                     leaf ipv6-prefix {
 *                                         type ipv6-prefix;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix-binary {
 *                                     leaf ipv6-address-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                     leaf ipv6-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case key-value-address {
 *                                     container key-value-address {
 *                                         leaf key {
 *                                             type simple-address;
 *                                         }
 *                                         leaf value {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case mac {
 *                                     leaf mac {
 *                                         type mac-address;
 *                                     }
 *                                 }
 *                                 case nat-traversal {
 *                                     container nat-traversal {
 *                                         leaf ms-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf etr-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf global-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf ms-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf private-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf-list rtr-rlocs {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case no-address {
 *                                     leaf no-address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                                 case null-address {
 *                                     container null-address {
 *                                         leaf address {
 *                                             type empty;
 *                                         }
 *                                     }
 *                                 }
 *                                 case service-path {
 *                                     container service-path {
 *                                         leaf service-path-id {
 *                                             type service-path-id-type;
 *                                         }
 *                                         leaf service-index {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                 }
 *                                 case source-dest-key {
 *                                     container source-dest-key {
 *                                         leaf source {
 *                                             type simple-address;
 *                                         }
 *                                         leaf dest {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses augmented-lisp-address;
 *                         }
 *                         uses rloc-container;
 *                     }
 *                     uses eid-container;
 *                     uses mapping-record-metadata;
 *                     uses LocatorRecords;
 *                 }
 *                 uses mapping-record-container;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc remove-all-operational-content {
 *         input {
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc remove-mapping {
 *         input {
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc update-keys {
 *         input {
 *             list eid-authkey-item {
 *                 key "eid-authkey-item-id";
 *                 leaf eid-authkey-item-id {
 *                     type string;
 *                 }
 *                 container mapping-authkey {
 *                     leaf key-string {
 *                         type string;
 *                     }
 *                     leaf key-type {
 *                         type uint16;
 *                     }
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-authkey-container;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc add-mappings {
 *         input {
 *             list mapping-record-item {
 *                 key "mapping-record-item-id";
 *                 leaf mapping-record-item-id {
 *                     type string;
 *                 }
 *                 container mapping-record {
 *                     leaf recordTtl {
 *                         type int32;
 *                     }
 *                     leaf mapVersion {
 *                         type int16;
 *                     }
 *                     leaf action {
 *                         type enumeration;
 *                     }
 *                     leaf authoritative {
 *                         type boolean;
 *                     }
 *                     leaf xtr-id {
 *                         type xtr-id;
 *                     }
 *                     leaf site-id {
 *                         type site-id;
 *                     }
 *                     leaf source-rloc {
 *                         type ip-address-binary;
 *                     }
 *                     leaf timestamp {
 *                         type int64;
 *                     }
 *                     container eid {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     list LocatorRecord {
 *                         key "locator-id";
 *                         leaf locator-id {
 *                             type string;
 *                         }
 *                         leaf priority {
 *                             type uint8;
 *                         }
 *                         leaf weight {
 *                             type uint8;
 *                         }
 *                         leaf multicastPriority {
 *                             type uint8;
 *                         }
 *                         leaf multicastWeight {
 *                             type uint8;
 *                         }
 *                         leaf localLocator {
 *                             type boolean;
 *                         }
 *                         leaf rlocProbed {
 *                             type boolean;
 *                         }
 *                         leaf routed {
 *                             type boolean;
 *                         }
 *                         container rloc {
 *                             leaf address-type {
 *                                 type lisp-address-family-ref;
 *                             }
 *                             leaf virtual-network-id {
 *                                 type instance-id-type;
 *                             }
 *                             choice address {
 *                                 case afi-list {
 *                                     container afi-list {
 *                                         leaf-list address-list {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case application-data {
 *                                     container application-data {
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf protocol {
 *                                             type uint8;
 *                                         }
 *                                         leaf ip-tos {
 *                                             type int32;
 *                                         }
 *                                         leaf local-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf local-port-high {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-low {
 *                                             type port-number;
 *                                         }
 *                                         leaf remote-port-high {
 *                                             type port-number;
 *                                         }
 *                                     }
 *                                 }
 *                                 case as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                 }
 *                                 case as-number-lcaf {
 *                                     container as-number-lcaf {
 *                                         leaf as {
 *                                             type as-number;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case distinguished-name {
 *                                     leaf distinguished-name {
 *                                         type distinguished-name-type;
 *                                     }
 *                                 }
 *                                 case explicit-locator-path {
 *                                     container explicit-locator-path {
 *                                         list hop {
 *                                             key "hop-id";
 *                                             leaf hop-id {
 *                                                 type string;
 *                                             }
 *                                             leaf address {
 *                                                 type simple-address;
 *                                             }
 *                                             leaf lrs-bits {
 *                                                 type bits;
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 case geo-coordinates {
 *                                     container geo-coordinates {
 *                                         leaf latitude {
 *                                             type bits;
 *                                         }
 *                                         leaf latitude-degrees {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf latitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude {
 *                                             type bits;
 *                                         }
 *                                         leaf longitude-degrees {
 *                                             type uint16;
 *                                         }
 *                                         leaf longitude-minutes {
 *                                             type uint8;
 *                                         }
 *                                         leaf longitude-seconds {
 *                                             type uint8;
 *                                         }
 *                                         leaf altitude {
 *                                             type int32;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case instance-id {
 *                                     container instance-id {
 *                                         leaf iid {
 *                                             type instance-id-type;
 *                                         }
 *                                         leaf mask-length {
 *                                             type uint8;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ipv4 {
 *                                     leaf ipv4 {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                                 case ipv4-binary {
 *                                     leaf ipv4-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix {
 *                                     leaf ipv4-prefix {
 *                                         type ipv4-prefix;
 *                                     }
 *                                 }
 *                                 case ipv4-prefix-binary {
 *                                     leaf ipv4-address-binary {
 *                                         type ipv4-address-binary;
 *                                     }
 *                                     leaf ipv4-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case ipv6 {
 *                                     leaf ipv6 {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                                 case ipv6-binary {
 *                                     leaf ipv6-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix {
 *                                     leaf ipv6-prefix {
 *                                         type ipv6-prefix;
 *                                     }
 *                                 }
 *                                 case ipv6-prefix-binary {
 *                                     leaf ipv6-address-binary {
 *                                         type ipv6-address-binary;
 *                                     }
 *                                     leaf ipv6-mask-length {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                                 case key-value-address {
 *                                     container key-value-address {
 *                                         leaf key {
 *                                             type simple-address;
 *                                         }
 *                                         leaf value {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case mac {
 *                                     leaf mac {
 *                                         type mac-address;
 *                                     }
 *                                 }
 *                                 case nat-traversal {
 *                                     container nat-traversal {
 *                                         leaf ms-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf etr-udp-port {
 *                                             type uint16;
 *                                         }
 *                                         leaf global-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf ms-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf private-etr-rloc {
 *                                             type simple-address;
 *                                         }
 *                                         leaf-list rtr-rlocs {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                                 case no-address {
 *                                     leaf no-address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                                 case null-address {
 *                                     container null-address {
 *                                         leaf address {
 *                                             type empty;
 *                                         }
 *                                     }
 *                                 }
 *                                 case service-path {
 *                                     container service-path {
 *                                         leaf service-path-id {
 *                                             type service-path-id-type;
 *                                         }
 *                                         leaf service-index {
 *                                             type uint8;
 *                                         }
 *                                     }
 *                                 }
 *                                 case source-dest-key {
 *                                     container source-dest-key {
 *                                         leaf source {
 *                                             type simple-address;
 *                                         }
 *                                         leaf dest {
 *                                             type simple-address;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses augmented-lisp-address;
 *                         }
 *                         uses rloc-container;
 *                     }
 *                     uses eid-container;
 *                     uses mapping-record-metadata;
 *                     uses LocatorRecords;
 *                 }
 *                 uses mapping-record-container;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc add-mapping {
 *         input {
 *             container mapping-record {
 *                 leaf recordTtl {
 *                     type int32;
 *                 }
 *                 leaf mapVersion {
 *                     type int16;
 *                 }
 *                 leaf action {
 *                     type enumeration;
 *                 }
 *                 leaf authoritative {
 *                     type boolean;
 *                 }
 *                 leaf xtr-id {
 *                     type xtr-id;
 *                 }
 *                 leaf site-id {
 *                     type site-id;
 *                 }
 *                 leaf source-rloc {
 *                     type ip-address-binary;
 *                 }
 *                 leaf timestamp {
 *                     type int64;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 list LocatorRecord {
 *                     key "locator-id";
 *                     leaf locator-id {
 *                         type string;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf weight {
 *                         type uint8;
 *                     }
 *                     leaf multicastPriority {
 *                         type uint8;
 *                     }
 *                     leaf multicastWeight {
 *                         type uint8;
 *                     }
 *                     leaf localLocator {
 *                         type boolean;
 *                     }
 *                     leaf rlocProbed {
 *                         type boolean;
 *                     }
 *                     leaf routed {
 *                         type boolean;
 *                     }
 *                     container rloc {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     uses rloc-container;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-record-metadata;
 *                 uses LocatorRecords;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc add-key {
 *         input {
 *             container eid {
 *                 leaf address-type {
 *                     type lisp-address-family-ref;
 *                 }
 *                 leaf virtual-network-id {
 *                     type instance-id-type;
 *                 }
 *                 choice address {
 *                     case afi-list {
 *                         container afi-list {
 *                             leaf-list address-list {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case application-data {
 *                         container application-data {
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                             leaf protocol {
 *                                 type uint8;
 *                             }
 *                             leaf ip-tos {
 *                                 type int32;
 *                             }
 *                             leaf local-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf local-port-high {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-low {
 *                                 type port-number;
 *                             }
 *                             leaf remote-port-high {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                     case as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                     }
 *                     case as-number-lcaf {
 *                         container as-number-lcaf {
 *                             leaf as {
 *                                 type as-number;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case distinguished-name {
 *                         leaf distinguished-name {
 *                             type distinguished-name-type;
 *                         }
 *                     }
 *                     case explicit-locator-path {
 *                         container explicit-locator-path {
 *                             list hop {
 *                                 key "hop-id";
 *                                 leaf hop-id {
 *                                     type string;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf lrs-bits {
 *                                     type bits;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     case geo-coordinates {
 *                         container geo-coordinates {
 *                             leaf latitude {
 *                                 type bits;
 *                             }
 *                             leaf latitude-degrees {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf latitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf longitude {
 *                                 type bits;
 *                             }
 *                             leaf longitude-degrees {
 *                                 type uint16;
 *                             }
 *                             leaf longitude-minutes {
 *                                 type uint8;
 *                             }
 *                             leaf longitude-seconds {
 *                                 type uint8;
 *                             }
 *                             leaf altitude {
 *                                 type int32;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case instance-id {
 *                         container instance-id {
 *                             leaf iid {
 *                                 type instance-id-type;
 *                             }
 *                             leaf mask-length {
 *                                 type uint8;
 *                             }
 *                             leaf address {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case ipv4 {
 *                         leaf ipv4 {
 *                             type ipv4-address;
 *                         }
 *                     }
 *                     case ipv4-binary {
 *                         leaf ipv4-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                     }
 *                     case ipv4-prefix {
 *                         leaf ipv4-prefix {
 *                             type ipv4-prefix;
 *                         }
 *                     }
 *                     case ipv4-prefix-binary {
 *                         leaf ipv4-address-binary {
 *                             type ipv4-address-binary;
 *                         }
 *                         leaf ipv4-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case ipv6 {
 *                         leaf ipv6 {
 *                             type ipv6-address;
 *                         }
 *                     }
 *                     case ipv6-binary {
 *                         leaf ipv6-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                     }
 *                     case ipv6-prefix {
 *                         leaf ipv6-prefix {
 *                             type ipv6-prefix;
 *                         }
 *                     }
 *                     case ipv6-prefix-binary {
 *                         leaf ipv6-address-binary {
 *                             type ipv6-address-binary;
 *                         }
 *                         leaf ipv6-mask-length {
 *                             type uint8;
 *                         }
 *                     }
 *                     case key-value-address {
 *                         container key-value-address {
 *                             leaf key {
 *                                 type simple-address;
 *                             }
 *                             leaf value {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case mac {
 *                         leaf mac {
 *                             type mac-address;
 *                         }
 *                     }
 *                     case nat-traversal {
 *                         container nat-traversal {
 *                             leaf ms-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf etr-udp-port {
 *                                 type uint16;
 *                             }
 *                             leaf global-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf ms-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf private-etr-rloc {
 *                                 type simple-address;
 *                             }
 *                             leaf-list rtr-rlocs {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                     case no-address {
 *                         leaf no-address {
 *                             type empty;
 *                         }
 *                     }
 *                     case null-address {
 *                         container null-address {
 *                             leaf address {
 *                                 type empty;
 *                             }
 *                         }
 *                     }
 *                     case service-path {
 *                         container service-path {
 *                             leaf service-path-id {
 *                                 type service-path-id-type;
 *                             }
 *                             leaf service-index {
 *                                 type uint8;
 *                             }
 *                         }
 *                     }
 *                     case source-dest-key {
 *                         container source-dest-key {
 *                             leaf source {
 *                                 type simple-address;
 *                             }
 *                             leaf dest {
 *                                 type simple-address;
 *                             }
 *                         }
 *                     }
 *                 }
 *                 uses augmented-lisp-address;
 *             }
 *             container mapping-authkey {
 *                 leaf key-string {
 *                     type string;
 *                 }
 *                 leaf key-type {
 *                     type uint16;
 *                 }
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 *     rpc update-mapping {
 *         input {
 *             container mapping-record {
 *                 leaf recordTtl {
 *                     type int32;
 *                 }
 *                 leaf mapVersion {
 *                     type int16;
 *                 }
 *                 leaf action {
 *                     type enumeration;
 *                 }
 *                 leaf authoritative {
 *                     type boolean;
 *                 }
 *                 leaf xtr-id {
 *                     type xtr-id;
 *                 }
 *                 leaf site-id {
 *                     type site-id;
 *                 }
 *                 leaf source-rloc {
 *                     type ip-address-binary;
 *                 }
 *                 leaf timestamp {
 *                     type int64;
 *                 }
 *                 container eid {
 *                     leaf address-type {
 *                         type lisp-address-family-ref;
 *                     }
 *                     leaf virtual-network-id {
 *                         type instance-id-type;
 *                     }
 *                     choice address {
 *                         case afi-list {
 *                             container afi-list {
 *                                 leaf-list address-list {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case application-data {
 *                             container application-data {
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                                 leaf protocol {
 *                                     type uint8;
 *                                 }
 *                                 leaf ip-tos {
 *                                     type int32;
 *                                 }
 *                                 leaf local-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf local-port-high {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-low {
 *                                     type port-number;
 *                                 }
 *                                 leaf remote-port-high {
 *                                     type port-number;
 *                                 }
 *                             }
 *                         }
 *                         case as-number {
 *                             leaf as-number {
 *                                 type as-number;
 *                             }
 *                         }
 *                         case as-number-lcaf {
 *                             container as-number-lcaf {
 *                                 leaf as {
 *                                     type as-number;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case distinguished-name {
 *                             leaf distinguished-name {
 *                                 type distinguished-name-type;
 *                             }
 *                         }
 *                         case explicit-locator-path {
 *                             container explicit-locator-path {
 *                                 list hop {
 *                                     key "hop-id";
 *                                     leaf hop-id {
 *                                         type string;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf lrs-bits {
 *                                         type bits;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         case geo-coordinates {
 *                             container geo-coordinates {
 *                                 leaf latitude {
 *                                     type bits;
 *                                 }
 *                                 leaf latitude-degrees {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf latitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude {
 *                                     type bits;
 *                                 }
 *                                 leaf longitude-degrees {
 *                                     type uint16;
 *                                 }
 *                                 leaf longitude-minutes {
 *                                     type uint8;
 *                                 }
 *                                 leaf longitude-seconds {
 *                                     type uint8;
 *                                 }
 *                                 leaf altitude {
 *                                     type int32;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case instance-id {
 *                             container instance-id {
 *                                 leaf iid {
 *                                     type instance-id-type;
 *                                 }
 *                                 leaf mask-length {
 *                                     type uint8;
 *                                 }
 *                                 leaf address {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case ipv4 {
 *                             leaf ipv4 {
 *                                 type ipv4-address;
 *                             }
 *                         }
 *                         case ipv4-binary {
 *                             leaf ipv4-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                         }
 *                         case ipv4-prefix {
 *                             leaf ipv4-prefix {
 *                                 type ipv4-prefix;
 *                             }
 *                         }
 *                         case ipv4-prefix-binary {
 *                             leaf ipv4-address-binary {
 *                                 type ipv4-address-binary;
 *                             }
 *                             leaf ipv4-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case ipv6 {
 *                             leaf ipv6 {
 *                                 type ipv6-address;
 *                             }
 *                         }
 *                         case ipv6-binary {
 *                             leaf ipv6-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                         }
 *                         case ipv6-prefix {
 *                             leaf ipv6-prefix {
 *                                 type ipv6-prefix;
 *                             }
 *                         }
 *                         case ipv6-prefix-binary {
 *                             leaf ipv6-address-binary {
 *                                 type ipv6-address-binary;
 *                             }
 *                             leaf ipv6-mask-length {
 *                                 type uint8;
 *                             }
 *                         }
 *                         case key-value-address {
 *                             container key-value-address {
 *                                 leaf key {
 *                                     type simple-address;
 *                                 }
 *                                 leaf value {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case mac {
 *                             leaf mac {
 *                                 type mac-address;
 *                             }
 *                         }
 *                         case nat-traversal {
 *                             container nat-traversal {
 *                                 leaf ms-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf etr-udp-port {
 *                                     type uint16;
 *                                 }
 *                                 leaf global-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf ms-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf private-etr-rloc {
 *                                     type simple-address;
 *                                 }
 *                                 leaf-list rtr-rlocs {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                         case no-address {
 *                             leaf no-address {
 *                                 type empty;
 *                             }
 *                         }
 *                         case null-address {
 *                             container null-address {
 *                                 leaf address {
 *                                     type empty;
 *                                 }
 *                             }
 *                         }
 *                         case service-path {
 *                             container service-path {
 *                                 leaf service-path-id {
 *                                     type service-path-id-type;
 *                                 }
 *                                 leaf service-index {
 *                                     type uint8;
 *                                 }
 *                             }
 *                         }
 *                         case source-dest-key {
 *                             container source-dest-key {
 *                                 leaf source {
 *                                     type simple-address;
 *                                 }
 *                                 leaf dest {
 *                                     type simple-address;
 *                                 }
 *                             }
 *                         }
 *                     }
 *                     uses augmented-lisp-address;
 *                 }
 *                 list LocatorRecord {
 *                     key "locator-id";
 *                     leaf locator-id {
 *                         type string;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf weight {
 *                         type uint8;
 *                     }
 *                     leaf multicastPriority {
 *                         type uint8;
 *                     }
 *                     leaf multicastWeight {
 *                         type uint8;
 *                     }
 *                     leaf localLocator {
 *                         type boolean;
 *                     }
 *                     leaf rlocProbed {
 *                         type boolean;
 *                     }
 *                     leaf routed {
 *                         type boolean;
 *                     }
 *                     container rloc {
 *                         leaf address-type {
 *                             type lisp-address-family-ref;
 *                         }
 *                         leaf virtual-network-id {
 *                             type instance-id-type;
 *                         }
 *                         choice address {
 *                             case afi-list {
 *                                 container afi-list {
 *                                     leaf-list address-list {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case application-data {
 *                                 container application-data {
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                     leaf protocol {
 *                                         type uint8;
 *                                     }
 *                                     leaf ip-tos {
 *                                         type int32;
 *                                     }
 *                                     leaf local-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf local-port-high {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-low {
 *                                         type port-number;
 *                                     }
 *                                     leaf remote-port-high {
 *                                         type port-number;
 *                                     }
 *                                 }
 *                             }
 *                             case as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                             }
 *                             case as-number-lcaf {
 *                                 container as-number-lcaf {
 *                                     leaf as {
 *                                         type as-number;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case distinguished-name {
 *                                 leaf distinguished-name {
 *                                     type distinguished-name-type;
 *                                 }
 *                             }
 *                             case explicit-locator-path {
 *                                 container explicit-locator-path {
 *                                     list hop {
 *                                         key "hop-id";
 *                                         leaf hop-id {
 *                                             type string;
 *                                         }
 *                                         leaf address {
 *                                             type simple-address;
 *                                         }
 *                                         leaf lrs-bits {
 *                                             type bits;
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             case geo-coordinates {
 *                                 container geo-coordinates {
 *                                     leaf latitude {
 *                                         type bits;
 *                                     }
 *                                     leaf latitude-degrees {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf latitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude {
 *                                         type bits;
 *                                     }
 *                                     leaf longitude-degrees {
 *                                         type uint16;
 *                                     }
 *                                     leaf longitude-minutes {
 *                                         type uint8;
 *                                     }
 *                                     leaf longitude-seconds {
 *                                         type uint8;
 *                                     }
 *                                     leaf altitude {
 *                                         type int32;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case instance-id {
 *                                 container instance-id {
 *                                     leaf iid {
 *                                         type instance-id-type;
 *                                     }
 *                                     leaf mask-length {
 *                                         type uint8;
 *                                     }
 *                                     leaf address {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv4 {
 *                                 leaf ipv4 {
 *                                     type ipv4-address;
 *                                 }
 *                             }
 *                             case ipv4-binary {
 *                                 leaf ipv4-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                             }
 *                             case ipv4-prefix {
 *                                 leaf ipv4-prefix {
 *                                     type ipv4-prefix;
 *                                 }
 *                             }
 *                             case ipv4-prefix-binary {
 *                                 leaf ipv4-address-binary {
 *                                     type ipv4-address-binary;
 *                                 }
 *                                 leaf ipv4-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case ipv6 {
 *                                 leaf ipv6 {
 *                                     type ipv6-address;
 *                                 }
 *                             }
 *                             case ipv6-binary {
 *                                 leaf ipv6-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                             }
 *                             case ipv6-prefix {
 *                                 leaf ipv6-prefix {
 *                                     type ipv6-prefix;
 *                                 }
 *                             }
 *                             case ipv6-prefix-binary {
 *                                 leaf ipv6-address-binary {
 *                                     type ipv6-address-binary;
 *                                 }
 *                                 leaf ipv6-mask-length {
 *                                     type uint8;
 *                                 }
 *                             }
 *                             case key-value-address {
 *                                 container key-value-address {
 *                                     leaf key {
 *                                         type simple-address;
 *                                     }
 *                                     leaf value {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case mac {
 *                                 leaf mac {
 *                                     type mac-address;
 *                                 }
 *                             }
 *                             case nat-traversal {
 *                                 container nat-traversal {
 *                                     leaf ms-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf etr-udp-port {
 *                                         type uint16;
 *                                     }
 *                                     leaf global-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf ms-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf private-etr-rloc {
 *                                         type simple-address;
 *                                     }
 *                                     leaf-list rtr-rlocs {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                             case no-address {
 *                                 leaf no-address {
 *                                     type empty;
 *                                 }
 *                             }
 *                             case null-address {
 *                                 container null-address {
 *                                     leaf address {
 *                                         type empty;
 *                                     }
 *                                 }
 *                             }
 *                             case service-path {
 *                                 container service-path {
 *                                     leaf service-path-id {
 *                                         type service-path-id-type;
 *                                     }
 *                                     leaf service-index {
 *                                         type uint8;
 *                                     }
 *                                 }
 *                             }
 *                             case source-dest-key {
 *                                 container source-dest-key {
 *                                     leaf source {
 *                                         type simple-address;
 *                                     }
 *                                     leaf dest {
 *                                         type simple-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses augmented-lisp-address;
 *                     }
 *                     uses rloc-container;
 *                 }
 *                 uses eid-container;
 *                 uses mapping-record-metadata;
 *                 uses LocatorRecords;
 *             }
 *         }
 *         
 *         output {
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface OdlMappingserviceData
    extends
    DataRoot
{




    /**
     * The LISP EID-to-RLOC mapping database
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingDatabase</code> <code>mappingDatabase</code>, or <code>null</code> if not present
     */
    MappingDatabase getMappingDatabase();

}

