package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;

/**
 * A classifier for xtr-id elements which allows direct access to a particular 
 * element in the data tree.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * identity xtrid-context {
 *     description
 *         "A classifier for xtr-id elements which allows direct access to a particular element in the data tree.";
 *     status CURRENT;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/xtrid-context</i>
 *
 */
public abstract class XtridContext extends BaseIdentity
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:mappingservice",
        "2015-09-06", "xtrid-context").intern();


    public XtridContext() {
    
    
    }
    






}

