package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import java.util.Objects;

public class AuthenticationKeyKey
 implements Identifier<AuthenticationKey> {
    private static final long serialVersionUID = 1037997786839588133L;
    private final EidUri _eidUri;


    public AuthenticationKeyKey(EidUri _eidUri) {
    
    
        this._eidUri = _eidUri;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public AuthenticationKeyKey(AuthenticationKeyKey source) {
        this._eidUri = source._eidUri;
    }


    public EidUri getEidUri() {
        return _eidUri;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_eidUri);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationKeyKey other = (AuthenticationKeyKey) obj;
        if (!Objects.equals(_eidUri, other._eidUri)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.AuthenticationKeyKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_eidUri != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_eidUri=");
            builder.append(_eidUri);
        }
        return builder.append(']').toString();
    }
}

