package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.SiteId;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.record.container.MappingRecord;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMapping;
import java.util.List;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping
 *
 */
public class MappingBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping> {

    private EidUri _eidUri;
    private MappingKey _key;
    private MappingRecord _mappingRecord;
    private MappingOrigin _origin;
    private List<SiteId> _siteId;
    private List<XtrIdMapping> _xtrIdMapping;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>> augmentation = Collections.emptyMap();

    public MappingBuilder() {
    }
    public MappingBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer arg) {
        this._mappingRecord = arg.getMappingRecord();
    }

    public MappingBuilder(Mapping base) {
        if (base.getKey() == null) {
            this._key = new MappingKey(
                base.getEidUri(), 
                base.getOrigin()
            );
            this._eidUri = base.getEidUri();
            this._origin = base.getOrigin();
        } else {
            this._key = base.getKey();
            this._eidUri = _key.getEidUri();
            this._origin = _key.getOrigin();
        }
        this._mappingRecord = base.getMappingRecord();
        this._siteId = base.getSiteId();
        this._xtrIdMapping = base.getXtrIdMapping();
        if (base instanceof MappingImpl) {
            MappingImpl impl = (MappingImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer) {
            this._mappingRecord = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer)arg).getMappingRecord();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingRecordContainer] \n" +
              "but was: " + arg
            );
        }
    }

    public EidUri getEidUri() {
        return _eidUri;
    }
    
    public MappingKey getKey() {
        return _key;
    }
    
    public MappingRecord getMappingRecord() {
        return _mappingRecord;
    }
    
    public MappingOrigin getOrigin() {
        return _origin;
    }
    
    public List<SiteId> getSiteId() {
        return _siteId;
    }
    
    public List<XtrIdMapping> getXtrIdMapping() {
        return _xtrIdMapping;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public MappingBuilder setEidUri(final EidUri value) {
        this._eidUri = value;
        return this;
    }
    
     
    public MappingBuilder setKey(final MappingKey value) {
        this._key = value;
        return this;
    }
    
     
    public MappingBuilder setMappingRecord(final MappingRecord value) {
        this._mappingRecord = value;
        return this;
    }
    
     
    public MappingBuilder setOrigin(final MappingOrigin value) {
        this._origin = value;
        return this;
    }
    
     
    public MappingBuilder setSiteId(final List<SiteId> value) {
        this._siteId = value;
        return this;
    }
    
     
    public MappingBuilder setXtrIdMapping(final List<XtrIdMapping> value) {
        this._xtrIdMapping = value;
        return this;
    }
    
    public MappingBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public MappingBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Mapping build() {
        return new MappingImpl(this);
    }

    private static final class MappingImpl implements Mapping {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping.class;
        }

        private final EidUri _eidUri;
        private final MappingKey _key;
        private final MappingRecord _mappingRecord;
        private final MappingOrigin _origin;
        private final List<SiteId> _siteId;
        private final List<XtrIdMapping> _xtrIdMapping;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>> augmentation = Collections.emptyMap();

        private MappingImpl(MappingBuilder base) {
            if (base.getKey() == null) {
                this._key = new MappingKey(
                    base.getEidUri(), 
                    base.getOrigin()
                );
                this._eidUri = base.getEidUri();
                this._origin = base.getOrigin();
            } else {
                this._key = base.getKey();
                this._eidUri = _key.getEidUri();
                this._origin = _key.getOrigin();
            }
            this._mappingRecord = base.getMappingRecord();
            this._siteId = base.getSiteId();
            this._xtrIdMapping = base.getXtrIdMapping();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public EidUri getEidUri() {
            return _eidUri;
        }
        
        @Override
        public MappingKey getKey() {
            return _key;
        }
        
        @Override
        public MappingRecord getMappingRecord() {
            return _mappingRecord;
        }
        
        @Override
        public MappingOrigin getOrigin() {
            return _origin;
        }
        
        @Override
        public List<SiteId> getSiteId() {
            return _siteId;
        }
        
        @Override
        public List<XtrIdMapping> getXtrIdMapping() {
            return _xtrIdMapping;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_eidUri);
            result = prime * result + Objects.hashCode(_key);
            result = prime * result + Objects.hashCode(_mappingRecord);
            result = prime * result + Objects.hashCode(_origin);
            result = prime * result + Objects.hashCode(_siteId);
            result = prime * result + Objects.hashCode(_xtrIdMapping);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping other = (org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping)obj;
            if (!Objects.equals(_eidUri, other.getEidUri())) {
                return false;
            }
            if (!Objects.equals(_key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(_mappingRecord, other.getMappingRecord())) {
                return false;
            }
            if (!Objects.equals(_origin, other.getOrigin())) {
                return false;
            }
            if (!Objects.equals(_siteId, other.getSiteId())) {
                return false;
            }
            if (!Objects.equals(_xtrIdMapping, other.getXtrIdMapping())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MappingImpl otherImpl = (MappingImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.Mapping>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Mapping [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_eidUri != null) {
                builder.append("_eidUri=");
                builder.append(_eidUri);
                builder.append(", ");
            }
            if (_key != null) {
                builder.append("_key=");
                builder.append(_key);
                builder.append(", ");
            }
            if (_mappingRecord != null) {
                builder.append("_mappingRecord=");
                builder.append(_mappingRecord);
                builder.append(", ");
            }
            if (_origin != null) {
                builder.append("_origin=");
                builder.append(_origin);
                builder.append(", ");
            }
            if (_siteId != null) {
                builder.append("_siteId=");
                builder.append(_siteId);
                builder.append(", ");
            }
            if (_xtrIdMapping != null) {
                builder.append("_xtrIdMapping=");
                builder.append(_xtrIdMapping);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
