package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingOrigin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.EidUri;
import java.util.Objects;

public class MappingKey
 implements Identifier<Mapping> {
    private static final long serialVersionUID = -3556653507644188538L;
    private final EidUri _eidUri;
    private final MappingOrigin _origin;


    public MappingKey(EidUri _eidUri, MappingOrigin _origin) {
    
    
        this._eidUri = _eidUri;
        this._origin = _origin;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public MappingKey(MappingKey source) {
        this._eidUri = source._eidUri;
        this._origin = source._origin;
    }


    public EidUri getEidUri() {
        return _eidUri;
    }
    
    public MappingOrigin getOrigin() {
        return _origin;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_eidUri);
        result = prime * result + Objects.hashCode(_origin);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        MappingKey other = (MappingKey) obj;
        if (!Objects.equals(_eidUri, other._eidUri)) {
            return false;
        }
        if (!Objects.equals(_origin, other._origin)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.MappingKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_eidUri != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_eidUri=");
            builder.append(_eidUri);
        }
        if (_origin != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_origin=");
            builder.append(_origin);
        }
        return builder.append(']').toString();
    }
}

