package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping;
import org.opendaylight.yangtools.yang.binding.Identifier;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.XtrIdUri;

public class XtrIdMappingKey
 implements Identifier<XtrIdMapping> {
    private static final long serialVersionUID = -8832823683084686280L;
    private final XtrIdUri _xtrIdUri;


    public XtrIdMappingKey(XtrIdUri _xtrIdUri) {
    
    
        this._xtrIdUri = _xtrIdUri;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public XtrIdMappingKey(XtrIdMappingKey source) {
        this._xtrIdUri = source._xtrIdUri;
    }


    public XtrIdUri getXtrIdUri() {
        return _xtrIdUri;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_xtrIdUri);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        XtrIdMappingKey other = (XtrIdMappingKey) obj;
        if (!Objects.equals(_xtrIdUri, other._xtrIdUri)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.db.instance.mapping.XtrIdMappingKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_xtrIdUri != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_xtrIdUri=");
            builder.append(_xtrIdUri);
        }
        return builder.append(']').toString();
    }
}

