package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.eid.container.Eid;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.mapping.authkey.container.MappingAuthkey;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem
 *
 */
public class EidAuthkeyItemBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem> {

    private Eid _eid;
    private java.lang.String _eidAuthkeyItemId;
    private EidAuthkeyItemKey _key;
    private MappingAuthkey _mappingAuthkey;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>> augmentation = Collections.emptyMap();

    public EidAuthkeyItemBuilder() {
    }
    public EidAuthkeyItemBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer arg) {
        this._eid = arg.getEid();
    }
    public EidAuthkeyItemBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer arg) {
        this._mappingAuthkey = arg.getMappingAuthkey();
    }

    public EidAuthkeyItemBuilder(EidAuthkeyItem base) {
        if (base.getKey() == null) {
            this._key = new EidAuthkeyItemKey(
                base.getEidAuthkeyItemId()
            );
            this._eidAuthkeyItemId = base.getEidAuthkeyItemId();
        } else {
            this._key = base.getKey();
            this._eidAuthkeyItemId = _key.getEidAuthkeyItemId();
        }
        this._eid = base.getEid();
        this._mappingAuthkey = base.getMappingAuthkey();
        if (base instanceof EidAuthkeyItemImpl) {
            EidAuthkeyItemImpl impl = (EidAuthkeyItemImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer) {
            this._mappingAuthkey = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer)arg).getMappingAuthkey();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer) {
            this._eid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer)arg).getEid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer, org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.EidContainer] \n" +
              "but was: " + arg
            );
        }
    }

    public Eid getEid() {
        return _eid;
    }
    
    public java.lang.String getEidAuthkeyItemId() {
        return _eidAuthkeyItemId;
    }
    
    public EidAuthkeyItemKey getKey() {
        return _key;
    }
    
    public MappingAuthkey getMappingAuthkey() {
        return _mappingAuthkey;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public EidAuthkeyItemBuilder setEid(final Eid value) {
        this._eid = value;
        return this;
    }
    
     
    public EidAuthkeyItemBuilder setEidAuthkeyItemId(final java.lang.String value) {
        this._eidAuthkeyItemId = value;
        return this;
    }
    
     
    public EidAuthkeyItemBuilder setKey(final EidAuthkeyItemKey value) {
        this._key = value;
        return this;
    }
    
     
    public EidAuthkeyItemBuilder setMappingAuthkey(final MappingAuthkey value) {
        this._mappingAuthkey = value;
        return this;
    }
    
    public EidAuthkeyItemBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public EidAuthkeyItemBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public EidAuthkeyItem build() {
        return new EidAuthkeyItemImpl(this);
    }

    private static final class EidAuthkeyItemImpl implements EidAuthkeyItem {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem.class;
        }

        private final Eid _eid;
        private final java.lang.String _eidAuthkeyItemId;
        private final EidAuthkeyItemKey _key;
        private final MappingAuthkey _mappingAuthkey;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>> augmentation = Collections.emptyMap();

        private EidAuthkeyItemImpl(EidAuthkeyItemBuilder base) {
            if (base.getKey() == null) {
                this._key = new EidAuthkeyItemKey(
                    base.getEidAuthkeyItemId()
                );
                this._eidAuthkeyItemId = base.getEidAuthkeyItemId();
            } else {
                this._key = base.getKey();
                this._eidAuthkeyItemId = _key.getEidAuthkeyItemId();
            }
            this._eid = base.getEid();
            this._mappingAuthkey = base.getMappingAuthkey();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Eid getEid() {
            return _eid;
        }
        
        @Override
        public java.lang.String getEidAuthkeyItemId() {
            return _eidAuthkeyItemId;
        }
        
        @Override
        public EidAuthkeyItemKey getKey() {
            return _key;
        }
        
        @Override
        public MappingAuthkey getMappingAuthkey() {
            return _mappingAuthkey;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_eid);
            result = prime * result + Objects.hashCode(_eidAuthkeyItemId);
            result = prime * result + Objects.hashCode(_key);
            result = prime * result + Objects.hashCode(_mappingAuthkey);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem other = (org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem)obj;
            if (!Objects.equals(_eid, other.getEid())) {
                return false;
            }
            if (!Objects.equals(_eidAuthkeyItemId, other.getEidAuthkeyItemId())) {
                return false;
            }
            if (!Objects.equals(_key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(_mappingAuthkey, other.getMappingAuthkey())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                EidAuthkeyItemImpl otherImpl = (EidAuthkeyItemImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.eid.authkey.list.EidAuthkeyItem>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "EidAuthkeyItem [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_eid != null) {
                builder.append("_eid=");
                builder.append(_eid);
                builder.append(", ");
            }
            if (_eidAuthkeyItemId != null) {
                builder.append("_eidAuthkeyItemId=");
                builder.append(_eidAuthkeyItemId);
                builder.append(", ");
            }
            if (_key != null) {
                builder.append("_key=");
                builder.append(_key);
                builder.append(", ");
            }
            if (_mappingAuthkey != null) {
                builder.append("_mappingAuthkey=");
                builder.append(_mappingAuthkey);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
