package org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.lisp.proto.rev151105.MappingAuthkeyContainer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.MappingAuthkeyList;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-mappingservice</b>
 * <pre>
 * list mapping-authkey-item {
 *     key "mapping-authkey-item-id";
 *     leaf mapping-authkey-item-id {
 *         type string;
 *     }
 *     container mapping-authkey {
 *         leaf key-string {
 *             type string;
 *         }
 *         leaf key-type {
 *             type uint16;
 *         }
 *     }
 *     uses mapping-authkey-container;
 * }
 * </pre>The schema path to identify an instance is
 * <i>odl-mappingservice/mapping-authkey-list/mapping-authkey-item</i>
 *
 * <p>To create instances of this class use {@link MappingAuthkeyItemBuilder}.
 * @see MappingAuthkeyItemBuilder
 * @see MappingAuthkeyItemKey
 *
 */
public interface MappingAuthkeyItem
    extends
    ChildOf<MappingAuthkeyList>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItem>,
    MappingAuthkeyContainer,
    Identifiable<MappingAuthkeyItemKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:lfm:mappingservice",
        "2015-09-06", "mapping-authkey-item").intern();

    /**
     * @return <code>java.lang.String</code> <code>mappingAuthkeyItemId</code>, or <code>null</code> if not present
     */
    java.lang.String getMappingAuthkeyItemId();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.lfm.mappingservice.rev150906.mapping.authkey.list.MappingAuthkeyItemKey</code> <code>key</code>, or <code>null</code> if not present
     */
    MappingAuthkeyItemKey getKey();

}

